# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchingIssueEntry(object):
    """
    Patching issue found during an Exadata Fleet Update Readiness Check run.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchingIssueEntry object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this PatchingIssueEntry.
        :type name: str

        :param description:
            The value to assign to the description property of this PatchingIssueEntry.
        :type description: str

        :param impacted_resource_id:
            The value to assign to the impacted_resource_id property of this PatchingIssueEntry.
        :type impacted_resource_id: str

        :param recommended_action:
            The value to assign to the recommended_action property of this PatchingIssueEntry.
        :type recommended_action: str

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'impacted_resource_id': 'str',
            'recommended_action': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'impacted_resource_id': 'impactedResourceId',
            'recommended_action': 'recommendedAction'
        }
        self._name = None
        self._description = None
        self._impacted_resource_id = None
        self._recommended_action = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this PatchingIssueEntry.
        Name of the patching issue.


        :return: The name of this PatchingIssueEntry.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PatchingIssueEntry.
        Name of the patching issue.


        :param name: The name of this PatchingIssueEntry.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this PatchingIssueEntry.
        Description of the patching issue.


        :return: The description of this PatchingIssueEntry.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PatchingIssueEntry.
        Description of the patching issue.


        :param description: The description of this PatchingIssueEntry.
        :type: str
        """
        self._description = description

    @property
    def impacted_resource_id(self):
        """
        **[Required]** Gets the impacted_resource_id of this PatchingIssueEntry.
        The `OCID`__ of the resource impacted by the patching issue.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The impacted_resource_id of this PatchingIssueEntry.
        :rtype: str
        """
        return self._impacted_resource_id

    @impacted_resource_id.setter
    def impacted_resource_id(self, impacted_resource_id):
        """
        Sets the impacted_resource_id of this PatchingIssueEntry.
        The `OCID`__ of the resource impacted by the patching issue.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param impacted_resource_id: The impacted_resource_id of this PatchingIssueEntry.
        :type: str
        """
        self._impacted_resource_id = impacted_resource_id

    @property
    def recommended_action(self):
        """
        Gets the recommended_action of this PatchingIssueEntry.
        Recommended action to perform to address or further triage the patching issue.


        :return: The recommended_action of this PatchingIssueEntry.
        :rtype: str
        """
        return self._recommended_action

    @recommended_action.setter
    def recommended_action(self, recommended_action):
        """
        Sets the recommended_action of this PatchingIssueEntry.
        Recommended action to perform to address or further triage the patching issue.


        :param recommended_action: The recommended_action of this PatchingIssueEntry.
        :type: str
        """
        self._recommended_action = recommended_action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
