# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .gi_fleet_discovery_filter import GiFleetDiscoveryFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GiDefinedTagsFilter(GiFleetDiscoveryFilter):
    """
    Defined tags to include in the discovery.
    """

    #: A constant which can be used with the operator property of a GiDefinedTagsFilter.
    #: This constant has a value of "AND"
    OPERATOR_AND = "AND"

    #: A constant which can be used with the operator property of a GiDefinedTagsFilter.
    #: This constant has a value of "OR"
    OPERATOR_OR = "OR"

    def __init__(self, **kwargs):
        """
        Initializes a new GiDefinedTagsFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GiDefinedTagsFilter.type` attribute
        of this class is ``DEFINED_TAG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GiDefinedTagsFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID"
        :type type: str

        :param mode:
            The value to assign to the mode property of this GiDefinedTagsFilter.
            Allowed values for this property are: "INCLUDE", "EXCLUDE"
        :type mode: str

        :param tags:
            The value to assign to the tags property of this GiDefinedTagsFilter.
        :type tags: list[oci.fleet_software_update.models.DefinedTagFilterEntry]

        :param operator:
            The value to assign to the operator property of this GiDefinedTagsFilter.
            Allowed values for this property are: "AND", "OR"
        :type operator: str

        """
        self.swagger_types = {
            'type': 'str',
            'mode': 'str',
            'tags': 'list[DefinedTagFilterEntry]',
            'operator': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'mode': 'mode',
            'tags': 'tags',
            'operator': 'operator'
        }
        self._type = None
        self._mode = None
        self._tags = None
        self._operator = None
        self._type = 'DEFINED_TAG'

    @property
    def tags(self):
        """
        **[Required]** Gets the tags of this GiDefinedTagsFilter.
        Defined tags to include in the discovery.


        :return: The tags of this GiDefinedTagsFilter.
        :rtype: list[oci.fleet_software_update.models.DefinedTagFilterEntry]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this GiDefinedTagsFilter.
        Defined tags to include in the discovery.


        :param tags: The tags of this GiDefinedTagsFilter.
        :type: list[oci.fleet_software_update.models.DefinedTagFilterEntry]
        """
        self._tags = tags

    @property
    def operator(self):
        """
        Gets the operator of this GiDefinedTagsFilter.
        Type of join for each element in this filter.

        Allowed values for this property are: "AND", "OR"


        :return: The operator of this GiDefinedTagsFilter.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this GiDefinedTagsFilter.
        Type of join for each element in this filter.


        :param operator: The operator of this GiDefinedTagsFilter.
        :type: str
        """
        allowed_values = ["AND", "OR"]
        if not value_allowed_none_or_none_sentinel(operator, allowed_values):
            raise ValueError(
                f"Invalid value for `operator`, must be None or one of {allowed_values}"
            )
        self._operator = operator

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
