# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .create_fsu_readiness_check_details import CreateFsuReadinessCheckDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateTargetFsuReadinessCheckDetails(CreateFsuReadinessCheckDetails):
    """
    Details to create an Exadata Fleet Update Readiness Check for one or more target resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateTargetFsuReadinessCheckDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.CreateTargetFsuReadinessCheckDetails.type` attribute
        of this class is ``TARGET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateTargetFsuReadinessCheckDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateTargetFsuReadinessCheckDetails.
        :type compartment_id: str

        :param type:
            The value to assign to the type property of this CreateTargetFsuReadinessCheckDetails.
        :type type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateTargetFsuReadinessCheckDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateTargetFsuReadinessCheckDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param targets:
            The value to assign to the targets property of this CreateTargetFsuReadinessCheckDetails.
        :type targets: list[oci.fleet_software_update.models.ReadinessCheckTargetEntry]

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'targets': 'list[ReadinessCheckTargetEntry]'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'type': 'type',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'targets': 'targets'
        }
        self._display_name = None
        self._compartment_id = None
        self._type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._targets = None
        self._type = 'TARGET'

    @property
    def targets(self):
        """
        Gets the targets of this CreateTargetFsuReadinessCheckDetails.
        List of targets that will run the Exadata Fleet Update Readiness Check.
        The targets have to be of the same entity type.


        :return: The targets of this CreateTargetFsuReadinessCheckDetails.
        :rtype: list[oci.fleet_software_update.models.ReadinessCheckTargetEntry]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this CreateTargetFsuReadinessCheckDetails.
        List of targets that will run the Exadata Fleet Update Readiness Check.
        The targets have to be of the same entity type.


        :param targets: The targets of this CreateTargetFsuReadinessCheckDetails.
        :type: list[oci.fleet_software_update.models.ReadinessCheckTargetEntry]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
