# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateRunbookVersionDetails(object):
    """
    The information to be updated.
    Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateRunbookVersionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tasks:
            The value to assign to the tasks property of this UpdateRunbookVersionDetails.
        :type tasks: list[oci.fleet_apps_management.models.Task]

        :param groups:
            The value to assign to the groups property of this UpdateRunbookVersionDetails.
        :type groups: list[oci.fleet_apps_management.models.Group]

        :param execution_workflow_details:
            The value to assign to the execution_workflow_details property of this UpdateRunbookVersionDetails.
        :type execution_workflow_details: oci.fleet_apps_management.models.ExecutionWorkflowDetails

        :param rollback_workflow_details:
            The value to assign to the rollback_workflow_details property of this UpdateRunbookVersionDetails.
        :type rollback_workflow_details: oci.fleet_apps_management.models.RollbackWorkflowDetails

        """
        self.swagger_types = {
            'tasks': 'list[Task]',
            'groups': 'list[Group]',
            'execution_workflow_details': 'ExecutionWorkflowDetails',
            'rollback_workflow_details': 'RollbackWorkflowDetails'
        }
        self.attribute_map = {
            'tasks': 'tasks',
            'groups': 'groups',
            'execution_workflow_details': 'executionWorkflowDetails',
            'rollback_workflow_details': 'rollbackWorkflowDetails'
        }
        self._tasks = None
        self._groups = None
        self._execution_workflow_details = None
        self._rollback_workflow_details = None

    @property
    def tasks(self):
        """
        Gets the tasks of this UpdateRunbookVersionDetails.
        A set of tasks to execute in the runbook.


        :return: The tasks of this UpdateRunbookVersionDetails.
        :rtype: list[oci.fleet_apps_management.models.Task]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """
        Sets the tasks of this UpdateRunbookVersionDetails.
        A set of tasks to execute in the runbook.


        :param tasks: The tasks of this UpdateRunbookVersionDetails.
        :type: list[oci.fleet_apps_management.models.Task]
        """
        self._tasks = tasks

    @property
    def groups(self):
        """
        Gets the groups of this UpdateRunbookVersionDetails.
        The groups of the runbook version.


        :return: The groups of this UpdateRunbookVersionDetails.
        :rtype: list[oci.fleet_apps_management.models.Group]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this UpdateRunbookVersionDetails.
        The groups of the runbook version.


        :param groups: The groups of this UpdateRunbookVersionDetails.
        :type: list[oci.fleet_apps_management.models.Group]
        """
        self._groups = groups

    @property
    def execution_workflow_details(self):
        """
        Gets the execution_workflow_details of this UpdateRunbookVersionDetails.

        :return: The execution_workflow_details of this UpdateRunbookVersionDetails.
        :rtype: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        return self._execution_workflow_details

    @execution_workflow_details.setter
    def execution_workflow_details(self, execution_workflow_details):
        """
        Sets the execution_workflow_details of this UpdateRunbookVersionDetails.

        :param execution_workflow_details: The execution_workflow_details of this UpdateRunbookVersionDetails.
        :type: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        self._execution_workflow_details = execution_workflow_details

    @property
    def rollback_workflow_details(self):
        """
        Gets the rollback_workflow_details of this UpdateRunbookVersionDetails.

        :return: The rollback_workflow_details of this UpdateRunbookVersionDetails.
        :rtype: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        return self._rollback_workflow_details

    @rollback_workflow_details.setter
    def rollback_workflow_details(self, rollback_workflow_details):
        """
        Sets the rollback_workflow_details of this UpdateRunbookVersionDetails.

        :param rollback_workflow_details: The rollback_workflow_details of this UpdateRunbookVersionDetails.
        :type: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        self._rollback_workflow_details = rollback_workflow_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
