# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StackSource(object):
    """
    Object representing the source information for the stack, indicating origin type and a reference string.
    """

    #: A constant which can be used with the type property of a StackSource.
    #: This constant has a value of "MARKETPLACE"
    TYPE_MARKETPLACE = "MARKETPLACE"

    #: A constant which can be used with the type property of a StackSource.
    #: This constant has a value of "QUICKSTART"
    TYPE_QUICKSTART = "QUICKSTART"

    #: A constant which can be used with the type property of a StackSource.
    #: This constant has a value of "WEB"
    TYPE_WEB = "WEB"

    def __init__(self, **kwargs):
        """
        Initializes a new StackSource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this StackSource.
            Allowed values for this property are: "MARKETPLACE", "QUICKSTART", "WEB", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param reference:
            The value to assign to the reference property of this StackSource.
        :type reference: str

        """
        self.swagger_types = {
            'type': 'str',
            'reference': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'reference': 'reference'
        }
        self._type = None
        self._reference = None

    @property
    def type(self):
        """
        Gets the type of this StackSource.
        The source type of the stack (e.g. MARKETPLACE, QUICKSTART, or WEB).

        Allowed values for this property are: "MARKETPLACE", "QUICKSTART", "WEB", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this StackSource.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this StackSource.
        The source type of the stack (e.g. MARKETPLACE, QUICKSTART, or WEB).


        :param type: The type of this StackSource.
        :type: str
        """
        allowed_values = ["MARKETPLACE", "QUICKSTART", "WEB"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def reference(self):
        """
        Gets the reference of this StackSource.
        Reference string providing a pointer or identifier for the source.


        :return: The reference of this StackSource.
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """
        Sets the reference of this StackSource.
        Reference string providing a pointer or identifier for the source.


        :param reference: The reference of this StackSource.
        :type: str
        """
        self._reference = reference

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
