# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookTransferDependency(object):
    """
    Runbook transfer dependency.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookTransferDependency object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param prompt:
            The value to assign to the prompt property of this RunbookTransferDependency.
        :type prompt: oci.fleet_apps_management.models.Prompt

        :param placeholders:
            The value to assign to the placeholders property of this RunbookTransferDependency.
        :type placeholders: list[oci.fleet_apps_management.models.Placeholder]

        :param associations_found:
            The value to assign to the associations_found property of this RunbookTransferDependency.
        :type associations_found: list[oci.fleet_apps_management.models.Association]

        """
        self.swagger_types = {
            'prompt': 'Prompt',
            'placeholders': 'list[Placeholder]',
            'associations_found': 'list[Association]'
        }
        self.attribute_map = {
            'prompt': 'prompt',
            'placeholders': 'placeholders',
            'associations_found': 'associationsFound'
        }
        self._prompt = None
        self._placeholders = None
        self._associations_found = None

    @property
    def prompt(self):
        """
        Gets the prompt of this RunbookTransferDependency.

        :return: The prompt of this RunbookTransferDependency.
        :rtype: oci.fleet_apps_management.models.Prompt
        """
        return self._prompt

    @prompt.setter
    def prompt(self, prompt):
        """
        Sets the prompt of this RunbookTransferDependency.

        :param prompt: The prompt of this RunbookTransferDependency.
        :type: oci.fleet_apps_management.models.Prompt
        """
        self._prompt = prompt

    @property
    def placeholders(self):
        """
        Gets the placeholders of this RunbookTransferDependency.
        List of placeholders.


        :return: The placeholders of this RunbookTransferDependency.
        :rtype: list[oci.fleet_apps_management.models.Placeholder]
        """
        return self._placeholders

    @placeholders.setter
    def placeholders(self, placeholders):
        """
        Sets the placeholders of this RunbookTransferDependency.
        List of placeholders.


        :param placeholders: The placeholders of this RunbookTransferDependency.
        :type: list[oci.fleet_apps_management.models.Placeholder]
        """
        self._placeholders = placeholders

    @property
    def associations_found(self):
        """
        Gets the associations_found of this RunbookTransferDependency.
        List of associations found.


        :return: The associations_found of this RunbookTransferDependency.
        :rtype: list[oci.fleet_apps_management.models.Association]
        """
        return self._associations_found

    @associations_found.setter
    def associations_found(self, associations_found):
        """
        Sets the associations_found of this RunbookTransferDependency.
        List of associations found.


        :param associations_found: The associations_found of this RunbookTransferDependency.
        :type: list[oci.fleet_apps_management.models.Association]
        """
        self._associations_found = associations_found

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
