# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookImportDependencyFinderRequiredValue(object):
    """
    Runbook import required value.
    """

    #: A constant which can be used with the rendering_component property of a RunbookImportDependencyFinderRequiredValue.
    #: This constant has a value of "SINGLE_CHOICE"
    RENDERING_COMPONENT_SINGLE_CHOICE = "SINGLE_CHOICE"

    #: A constant which can be used with the rendering_component property of a RunbookImportDependencyFinderRequiredValue.
    #: This constant has a value of "MULTI_CHOICE"
    RENDERING_COMPONENT_MULTI_CHOICE = "MULTI_CHOICE"

    #: A constant which can be used with the rendering_component property of a RunbookImportDependencyFinderRequiredValue.
    #: This constant has a value of "INPUT_TEXT"
    RENDERING_COMPONENT_INPUT_TEXT = "INPUT_TEXT"

    #: A constant which can be used with the expected_assignment property of a RunbookImportDependencyFinderRequiredValue.
    #: This constant has a value of "TF_PACKAGE"
    EXPECTED_ASSIGNMENT_TF_PACKAGE = "TF_PACKAGE"

    #: A constant which can be used with the expected_assignment property of a RunbookImportDependencyFinderRequiredValue.
    #: This constant has a value of "NON_TF_PACKAGE"
    EXPECTED_ASSIGNMENT_NON_TF_PACKAGE = "NON_TF_PACKAGE"

    #: A constant which can be used with the expected_assignment property of a RunbookImportDependencyFinderRequiredValue.
    #: This constant has a value of "CONFIG_FILE"
    EXPECTED_ASSIGNMENT_CONFIG_FILE = "CONFIG_FILE"

    #: A constant which can be used with the expected_assignment property of a RunbookImportDependencyFinderRequiredValue.
    #: This constant has a value of "NULL"
    EXPECTED_ASSIGNMENT_NULL = "NULL"

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookImportDependencyFinderRequiredValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param rendering_component:
            The value to assign to the rendering_component property of this RunbookImportDependencyFinderRequiredValue.
            Allowed values for this property are: "SINGLE_CHOICE", "MULTI_CHOICE", "INPUT_TEXT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type rendering_component: str

        :param label:
            The value to assign to the label property of this RunbookImportDependencyFinderRequiredValue.
        :type label: str

        :param step_name:
            The value to assign to the step_name property of this RunbookImportDependencyFinderRequiredValue.
        :type step_name: str

        :param placeholder_assignment:
            The value to assign to the placeholder_assignment property of this RunbookImportDependencyFinderRequiredValue.
        :type placeholder_assignment: str

        :param expected_assignment:
            The value to assign to the expected_assignment property of this RunbookImportDependencyFinderRequiredValue.
            Allowed values for this property are: "TF_PACKAGE", "NON_TF_PACKAGE", "CONFIG_FILE", "NULL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type expected_assignment: str

        :param field:
            The value to assign to the field property of this RunbookImportDependencyFinderRequiredValue.
        :type field: str

        """
        self.swagger_types = {
            'rendering_component': 'str',
            'label': 'str',
            'step_name': 'str',
            'placeholder_assignment': 'str',
            'expected_assignment': 'str',
            'field': 'str'
        }
        self.attribute_map = {
            'rendering_component': 'renderingComponent',
            'label': 'label',
            'step_name': 'stepName',
            'placeholder_assignment': 'placeholderAssignment',
            'expected_assignment': 'expectedAssignment',
            'field': 'field'
        }
        self._rendering_component = None
        self._label = None
        self._step_name = None
        self._placeholder_assignment = None
        self._expected_assignment = None
        self._field = None

    @property
    def rendering_component(self):
        """
        Gets the rendering_component of this RunbookImportDependencyFinderRequiredValue.
        Rendering component value for required value.

        Allowed values for this property are: "SINGLE_CHOICE", "MULTI_CHOICE", "INPUT_TEXT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The rendering_component of this RunbookImportDependencyFinderRequiredValue.
        :rtype: str
        """
        return self._rendering_component

    @rendering_component.setter
    def rendering_component(self, rendering_component):
        """
        Sets the rendering_component of this RunbookImportDependencyFinderRequiredValue.
        Rendering component value for required value.


        :param rendering_component: The rendering_component of this RunbookImportDependencyFinderRequiredValue.
        :type: str
        """
        allowed_values = ["SINGLE_CHOICE", "MULTI_CHOICE", "INPUT_TEXT"]
        if not value_allowed_none_or_none_sentinel(rendering_component, allowed_values):
            rendering_component = 'UNKNOWN_ENUM_VALUE'
        self._rendering_component = rendering_component

    @property
    def label(self):
        """
        Gets the label of this RunbookImportDependencyFinderRequiredValue.
        Label for required value.


        :return: The label of this RunbookImportDependencyFinderRequiredValue.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this RunbookImportDependencyFinderRequiredValue.
        Label for required value.


        :param label: The label of this RunbookImportDependencyFinderRequiredValue.
        :type: str
        """
        self._label = label

    @property
    def step_name(self):
        """
        Gets the step_name of this RunbookImportDependencyFinderRequiredValue.
        Step name for required value.


        :return: The step_name of this RunbookImportDependencyFinderRequiredValue.
        :rtype: str
        """
        return self._step_name

    @step_name.setter
    def step_name(self, step_name):
        """
        Sets the step_name of this RunbookImportDependencyFinderRequiredValue.
        Step name for required value.


        :param step_name: The step_name of this RunbookImportDependencyFinderRequiredValue.
        :type: str
        """
        self._step_name = step_name

    @property
    def placeholder_assignment(self):
        """
        Gets the placeholder_assignment of this RunbookImportDependencyFinderRequiredValue.
        Placeholder assignment for required value.


        :return: The placeholder_assignment of this RunbookImportDependencyFinderRequiredValue.
        :rtype: str
        """
        return self._placeholder_assignment

    @placeholder_assignment.setter
    def placeholder_assignment(self, placeholder_assignment):
        """
        Sets the placeholder_assignment of this RunbookImportDependencyFinderRequiredValue.
        Placeholder assignment for required value.


        :param placeholder_assignment: The placeholder_assignment of this RunbookImportDependencyFinderRequiredValue.
        :type: str
        """
        self._placeholder_assignment = placeholder_assignment

    @property
    def expected_assignment(self):
        """
        Gets the expected_assignment of this RunbookImportDependencyFinderRequiredValue.
        Expected assignment.

        Allowed values for this property are: "TF_PACKAGE", "NON_TF_PACKAGE", "CONFIG_FILE", "NULL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The expected_assignment of this RunbookImportDependencyFinderRequiredValue.
        :rtype: str
        """
        return self._expected_assignment

    @expected_assignment.setter
    def expected_assignment(self, expected_assignment):
        """
        Sets the expected_assignment of this RunbookImportDependencyFinderRequiredValue.
        Expected assignment.


        :param expected_assignment: The expected_assignment of this RunbookImportDependencyFinderRequiredValue.
        :type: str
        """
        allowed_values = ["TF_PACKAGE", "NON_TF_PACKAGE", "CONFIG_FILE", "NULL"]
        if not value_allowed_none_or_none_sentinel(expected_assignment, allowed_values):
            expected_assignment = 'UNKNOWN_ENUM_VALUE'
        self._expected_assignment = expected_assignment

    @property
    def field(self):
        """
        **[Required]** Gets the field of this RunbookImportDependencyFinderRequiredValue.
        Field for required value.


        :return: The field of this RunbookImportDependencyFinderRequiredValue.
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """
        Sets the field of this RunbookImportDependencyFinderRequiredValue.
        Field for required value.


        :param field: The field of this RunbookImportDependencyFinderRequiredValue.
        :type: str
        """
        self._field = field

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
