# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceSelection(object):
    """
    Resource Selection Type
    """

    #: A constant which can be used with the resource_selection_type property of a ResourceSelection.
    #: This constant has a value of "DYNAMIC"
    RESOURCE_SELECTION_TYPE_DYNAMIC = "DYNAMIC"

    #: A constant which can be used with the resource_selection_type property of a ResourceSelection.
    #: This constant has a value of "MANUAL"
    RESOURCE_SELECTION_TYPE_MANUAL = "MANUAL"

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceSelection object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.DynamicResourceSelection`
        * :class:`~oci.fleet_apps_management.models.ManualResourceSelection`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_selection_type:
            The value to assign to the resource_selection_type property of this ResourceSelection.
            Allowed values for this property are: "DYNAMIC", "MANUAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_selection_type: str

        """
        self.swagger_types = {
            'resource_selection_type': 'str'
        }
        self.attribute_map = {
            'resource_selection_type': 'resourceSelectionType'
        }
        self._resource_selection_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['resourceSelectionType']

        if type == 'DYNAMIC':
            return 'DynamicResourceSelection'

        if type == 'MANUAL':
            return 'ManualResourceSelection'
        else:
            return 'ResourceSelection'

    @property
    def resource_selection_type(self):
        """
        **[Required]** Gets the resource_selection_type of this ResourceSelection.
        Type of resource selection in a Fleet.
        Select resources manually or select resources based on rules.

        Allowed values for this property are: "DYNAMIC", "MANUAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resource_selection_type of this ResourceSelection.
        :rtype: str
        """
        return self._resource_selection_type

    @resource_selection_type.setter
    def resource_selection_type(self, resource_selection_type):
        """
        Sets the resource_selection_type of this ResourceSelection.
        Type of resource selection in a Fleet.
        Select resources manually or select resources based on rules.


        :param resource_selection_type: The resource_selection_type of this ResourceSelection.
        :type: str
        """
        allowed_values = ["DYNAMIC", "MANUAL"]
        if not value_allowed_none_or_none_sentinel(resource_selection_type, allowed_values):
            resource_selection_type = 'UNKNOWN_ENUM_VALUE'
        self._resource_selection_type = resource_selection_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
