# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OutputVariableMapping(object):
    """
    Output variable to Input variable mapping details.
    Output variable of a task can be used as an input variable for a subsequent task.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OutputVariableMapping object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this OutputVariableMapping.
        :type name: str

        :param output_variable_details:
            The value to assign to the output_variable_details property of this OutputVariableMapping.
        :type output_variable_details: oci.fleet_apps_management.models.OutputVariableDetails

        """
        self.swagger_types = {
            'name': 'str',
            'output_variable_details': 'OutputVariableDetails'
        }
        self.attribute_map = {
            'name': 'name',
            'output_variable_details': 'outputVariableDetails'
        }
        self._name = None
        self._output_variable_details = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this OutputVariableMapping.
        The name of the input variable.


        :return: The name of this OutputVariableMapping.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OutputVariableMapping.
        The name of the input variable.


        :param name: The name of this OutputVariableMapping.
        :type: str
        """
        self._name = name

    @property
    def output_variable_details(self):
        """
        **[Required]** Gets the output_variable_details of this OutputVariableMapping.

        :return: The output_variable_details of this OutputVariableMapping.
        :rtype: oci.fleet_apps_management.models.OutputVariableDetails
        """
        return self._output_variable_details

    @output_variable_details.setter
    def output_variable_details(self, output_variable_details):
        """
        Sets the output_variable_details of this OutputVariableMapping.

        :param output_variable_details: The output_variable_details of this OutputVariableMapping.
        :type: oci.fleet_apps_management.models.OutputVariableDetails
        """
        self._output_variable_details = output_variable_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
