# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .filter import Filter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MultiValueFilter(Filter):
    """
    Content Source details.
    """

    #: A constant which can be used with the expression property of a MultiValueFilter.
    #: This constant has a value of "IN"
    EXPRESSION_IN = "IN"

    #: A constant which can be used with the expression property of a MultiValueFilter.
    #: This constant has a value of "NOT_IN"
    EXPRESSION_NOT_IN = "NOT_IN"

    #: A constant which can be used with the expression property of a MultiValueFilter.
    #: This constant has a value of "BETWEEN"
    EXPRESSION_BETWEEN = "BETWEEN"

    def __init__(self, **kwargs):
        """
        Initializes a new MultiValueFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.MultiValueFilter.filter_type` attribute
        of this class is ``MULTI_VALUE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param field_name:
            The value to assign to the field_name property of this MultiValueFilter.
        :type field_name: str

        :param filter_type:
            The value to assign to the filter_type property of this MultiValueFilter.
            Allowed values for this property are: "SINGLE_VALUE", "MULTI_VALUE"
        :type filter_type: str

        :param expression:
            The value to assign to the expression property of this MultiValueFilter.
            Allowed values for this property are: "IN", "NOT_IN", "BETWEEN"
        :type expression: str

        :param values:
            The value to assign to the values property of this MultiValueFilter.
        :type values: list[str]

        """
        self.swagger_types = {
            'field_name': 'str',
            'filter_type': 'str',
            'expression': 'str',
            'values': 'list[str]'
        }
        self.attribute_map = {
            'field_name': 'fieldName',
            'filter_type': 'filterType',
            'expression': 'expression',
            'values': 'values'
        }
        self._field_name = None
        self._filter_type = None
        self._expression = None
        self._values = None
        self._filter_type = 'MULTI_VALUE'

    @property
    def expression(self):
        """
        Gets the expression of this MultiValueFilter.
        Expression for Filter

        Allowed values for this property are: "IN", "NOT_IN", "BETWEEN"


        :return: The expression of this MultiValueFilter.
        :rtype: str
        """
        return self._expression

    @expression.setter
    def expression(self, expression):
        """
        Sets the expression of this MultiValueFilter.
        Expression for Filter


        :param expression: The expression of this MultiValueFilter.
        :type: str
        """
        allowed_values = ["IN", "NOT_IN", "BETWEEN"]
        if not value_allowed_none_or_none_sentinel(expression, allowed_values):
            raise ValueError(
                f"Invalid value for `expression`, must be None or one of {allowed_values}"
            )
        self._expression = expression

    @property
    def values(self):
        """
        Gets the values of this MultiValueFilter.
        Array of values.


        :return: The values of this MultiValueFilter.
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this MultiValueFilter.
        Array of values.


        :param values: The values of this MultiValueFilter.
        :type: list[str]
        """
        self._values = values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
