# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FindRunbookImportDependencyDetails(object):
    """
    Request to find runbook import dependencies.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FindRunbookImportDependencyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this FindRunbookImportDependencyDetails.
        :type compartment_id: str

        :param content:
            The value to assign to the content property of this FindRunbookImportDependencyDetails.
        :type content: oci.fleet_apps_management.models.TransferRunbookContentDetails

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'content': 'TransferRunbookContentDetails'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'content': 'content'
        }
        self._compartment_id = None
        self._content = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FindRunbookImportDependencyDetails.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this FindRunbookImportDependencyDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FindRunbookImportDependencyDetails.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this FindRunbookImportDependencyDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def content(self):
        """
        **[Required]** Gets the content of this FindRunbookImportDependencyDetails.

        :return: The content of this FindRunbookImportDependencyDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this FindRunbookImportDependencyDetails.

        :param content: The content of this FindRunbookImportDependencyDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content = content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
