# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .fleet_details import FleetDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EnvironmentFleetDetails(FleetDetails):
    """
    Fleet credential details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EnvironmentFleetDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.EnvironmentFleetDetails.fleet_type` attribute
        of this class is ``ENVIRONMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fleet_type:
            The value to assign to the fleet_type property of this EnvironmentFleetDetails.
            Allowed values for this property are: "GENERIC", "PRODUCT", "ENVIRONMENT", "GROUP"
        :type fleet_type: str

        """
        self.swagger_types = {
            'fleet_type': 'str'
        }
        self.attribute_map = {
            'fleet_type': 'fleetType'
        }
        self._fleet_type = None
        self._fleet_type = 'ENVIRONMENT'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
