# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Compliance(object):
    """
    Compliance Summary
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Compliance object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compliance_state:
            The value to assign to the compliance_state property of this Compliance.
        :type compliance_state: str

        :param confirmed_target_count:
            The value to assign to the confirmed_target_count property of this Compliance.
        :type confirmed_target_count: int

        :param non_compliant_target_count:
            The value to assign to the non_compliant_target_count property of this Compliance.
        :type non_compliant_target_count: int

        """
        self.swagger_types = {
            'compliance_state': 'str',
            'confirmed_target_count': 'int',
            'non_compliant_target_count': 'int'
        }
        self.attribute_map = {
            'compliance_state': 'complianceState',
            'confirmed_target_count': 'confirmedTargetCount',
            'non_compliant_target_count': 'nonCompliantTargetCount'
        }
        self._compliance_state = None
        self._confirmed_target_count = None
        self._non_compliant_target_count = None

    @property
    def compliance_state(self):
        """
        **[Required]** Gets the compliance_state of this Compliance.
        Compliance State.


        :return: The compliance_state of this Compliance.
        :rtype: str
        """
        return self._compliance_state

    @compliance_state.setter
    def compliance_state(self, compliance_state):
        """
        Sets the compliance_state of this Compliance.
        Compliance State.


        :param compliance_state: The compliance_state of this Compliance.
        :type: str
        """
        self._compliance_state = compliance_state

    @property
    def confirmed_target_count(self):
        """
        **[Required]** Gets the confirmed_target_count of this Compliance.
        Confirmed Target Count.


        :return: The confirmed_target_count of this Compliance.
        :rtype: int
        """
        return self._confirmed_target_count

    @confirmed_target_count.setter
    def confirmed_target_count(self, confirmed_target_count):
        """
        Sets the confirmed_target_count of this Compliance.
        Confirmed Target Count.


        :param confirmed_target_count: The confirmed_target_count of this Compliance.
        :type: int
        """
        self._confirmed_target_count = confirmed_target_count

    @property
    def non_compliant_target_count(self):
        """
        **[Required]** Gets the non_compliant_target_count of this Compliance.
        Non Compliant Target Count.


        :return: The non_compliant_target_count of this Compliance.
        :rtype: int
        """
        return self._non_compliant_target_count

    @non_compliant_target_count.setter
    def non_compliant_target_count(self, non_compliant_target_count):
        """
        Sets the non_compliant_target_count of this Compliance.
        Non Compliant Target Count.


        :param non_compliant_target_count: The non_compliant_target_count of this Compliance.
        :type: int
        """
        self._non_compliant_target_count = non_compliant_target_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
