# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .catalog_result_payload import CatalogResultPayload
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogParResultConfig(CatalogResultPayload):
    """
    Catalog par result config.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogParResultConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CatalogParResultConfig.config_result_type` attribute
        of this class is ``PAR_RESULT_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_result_type:
            The value to assign to the config_result_type property of this CatalogParResultConfig.
            Allowed values for this property are: "PAR_RESULT_CONFIG", "TEMPLATE_RESULT_CONFIG", "GIT_RESULT_CONFIG"
        :type config_result_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogParResultConfig.
        :type working_directory: str

        :param package_url:
            The value to assign to the package_url property of this CatalogParResultConfig.
        :type package_url: str

        :param time_expires:
            The value to assign to the time_expires property of this CatalogParResultConfig.
        :type time_expires: datetime

        """
        self.swagger_types = {
            'config_result_type': 'str',
            'working_directory': 'str',
            'package_url': 'str',
            'time_expires': 'datetime'
        }
        self.attribute_map = {
            'config_result_type': 'configResultType',
            'working_directory': 'workingDirectory',
            'package_url': 'packageUrl',
            'time_expires': 'timeExpires'
        }
        self._config_result_type = None
        self._working_directory = None
        self._package_url = None
        self._time_expires = None
        self._config_result_type = 'PAR_RESULT_CONFIG'

    @property
    def package_url(self):
        """
        Gets the package_url of this CatalogParResultConfig.
        package url


        :return: The package_url of this CatalogParResultConfig.
        :rtype: str
        """
        return self._package_url

    @package_url.setter
    def package_url(self, package_url):
        """
        Sets the package_url of this CatalogParResultConfig.
        package url


        :param package_url: The package_url of this CatalogParResultConfig.
        :type: str
        """
        self._package_url = package_url

    @property
    def time_expires(self):
        """
        Gets the time_expires of this CatalogParResultConfig.
        The date and time expires, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_expires of this CatalogParResultConfig.
        :rtype: datetime
        """
        return self._time_expires

    @time_expires.setter
    def time_expires(self, time_expires):
        """
        Sets the time_expires of this CatalogParResultConfig.
        The date and time expires, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_expires: The time_expires of this CatalogParResultConfig.
        :type: datetime
        """
        self._time_expires = time_expires

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
