# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .content_details import ContentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogContentDetails(ContentDetails):
    """
    Details for Terraform content.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogContentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CatalogContentDetails.source_type` attribute
        of this class is ``CATALOG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_type:
            The value to assign to the source_type property of this CatalogContentDetails.
            Allowed values for this property are: "OBJECT_STORAGE_BUCKET", "CATALOG"
        :type source_type: str

        :param catalog_id:
            The value to assign to the catalog_id property of this CatalogContentDetails.
        :type catalog_id: str

        """
        self.swagger_types = {
            'source_type': 'str',
            'catalog_id': 'str'
        }
        self.attribute_map = {
            'source_type': 'sourceType',
            'catalog_id': 'catalogId'
        }
        self._source_type = None
        self._catalog_id = None
        self._source_type = 'CATALOG'

    @property
    def catalog_id(self):
        """
        **[Required]** Gets the catalog_id of this CatalogContentDetails.
        Catalog Id having terraform package.


        :return: The catalog_id of this CatalogContentDetails.
        :rtype: str
        """
        return self._catalog_id

    @catalog_id.setter
    def catalog_id(self, catalog_id):
        """
        Sets the catalog_id of this CatalogContentDetails.
        Catalog Id having terraform package.


        :param catalog_id: The catalog_id of this CatalogContentDetails.
        :type: str
        """
        self._catalog_id = catalog_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
