# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutonomousDataBaseVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AutonomousDataBaseVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this AutonomousDataBaseVariableDependsOn.
        :type compartment_id: str

        :param db_workload:
            The value to assign to the db_workload property of this AutonomousDataBaseVariableDependsOn.
        :type db_workload: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'db_workload': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'db_workload': 'dbWorkload'
        }
        self._compartment_id = None
        self._db_workload = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AutonomousDataBaseVariableDependsOn.
        OCID of the compartment.


        :return: The compartment_id of this AutonomousDataBaseVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AutonomousDataBaseVariableDependsOn.
        OCID of the compartment.


        :param compartment_id: The compartment_id of this AutonomousDataBaseVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def db_workload(self):
        """
        Gets the db_workload of this AutonomousDataBaseVariableDependsOn.
        The database workload type.


        :return: The db_workload of this AutonomousDataBaseVariableDependsOn.
        :rtype: str
        """
        return self._db_workload

    @db_workload.setter
    def db_workload(self, db_workload):
        """
        Sets the db_workload of this AutonomousDataBaseVariableDependsOn.
        The database workload type.


        :param db_workload: The db_workload of this AutonomousDataBaseVariableDependsOn.
        :type: str
        """
        self._db_workload = db_workload

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
