# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedDbBackupDestination(object):
    """
    Backup destination details
    """

    #: A constant which can be used with the type property of a DistributedDbBackupDestination.
    #: This constant has a value of "NFS"
    TYPE_NFS = "NFS"

    #: A constant which can be used with the type property of a DistributedDbBackupDestination.
    #: This constant has a value of "RECOVERY_APPLIANCE"
    TYPE_RECOVERY_APPLIANCE = "RECOVERY_APPLIANCE"

    #: A constant which can be used with the type property of a DistributedDbBackupDestination.
    #: This constant has a value of "OBJECT_STORE"
    TYPE_OBJECT_STORE = "OBJECT_STORE"

    #: A constant which can be used with the type property of a DistributedDbBackupDestination.
    #: This constant has a value of "LOCAL"
    TYPE_LOCAL = "LOCAL"

    #: A constant which can be used with the type property of a DistributedDbBackupDestination.
    #: This constant has a value of "DBRS"
    TYPE_DBRS = "DBRS"

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedDbBackupDestination object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DistributedDbBackupDestination.
            Allowed values for this property are: "NFS", "RECOVERY_APPLIANCE", "OBJECT_STORE", "LOCAL", "DBRS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param id:
            The value to assign to the id property of this DistributedDbBackupDestination.
        :type id: str

        :param vpc_user:
            The value to assign to the vpc_user property of this DistributedDbBackupDestination.
        :type vpc_user: str

        :param vpc_password:
            The value to assign to the vpc_password property of this DistributedDbBackupDestination.
        :type vpc_password: str

        :param is_zero_data_loss_enabled:
            The value to assign to the is_zero_data_loss_enabled property of this DistributedDbBackupDestination.
        :type is_zero_data_loss_enabled: bool

        :param internet_proxy:
            The value to assign to the internet_proxy property of this DistributedDbBackupDestination.
        :type internet_proxy: str

        :param dbrs_policy_id:
            The value to assign to the dbrs_policy_id property of this DistributedDbBackupDestination.
        :type dbrs_policy_id: str

        :param is_remote:
            The value to assign to the is_remote property of this DistributedDbBackupDestination.
        :type is_remote: bool

        :param remote_region:
            The value to assign to the remote_region property of this DistributedDbBackupDestination.
        :type remote_region: str

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'vpc_user': 'str',
            'vpc_password': 'str',
            'is_zero_data_loss_enabled': 'bool',
            'internet_proxy': 'str',
            'dbrs_policy_id': 'str',
            'is_remote': 'bool',
            'remote_region': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'vpc_user': 'vpcUser',
            'vpc_password': 'vpcPassword',
            'is_zero_data_loss_enabled': 'isZeroDataLossEnabled',
            'internet_proxy': 'internetProxy',
            'dbrs_policy_id': 'dbrsPolicyId',
            'is_remote': 'isRemote',
            'remote_region': 'remoteRegion'
        }
        self._type = None
        self._id = None
        self._vpc_user = None
        self._vpc_password = None
        self._is_zero_data_loss_enabled = None
        self._internet_proxy = None
        self._dbrs_policy_id = None
        self._is_remote = None
        self._remote_region = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this DistributedDbBackupDestination.
        Type of the database backup destination.

        Allowed values for this property are: "NFS", "RECOVERY_APPLIANCE", "OBJECT_STORE", "LOCAL", "DBRS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this DistributedDbBackupDestination.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DistributedDbBackupDestination.
        Type of the database backup destination.


        :param type: The type of this DistributedDbBackupDestination.
        :type: str
        """
        allowed_values = ["NFS", "RECOVERY_APPLIANCE", "OBJECT_STORE", "LOCAL", "DBRS"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def id(self):
        """
        Gets the id of this DistributedDbBackupDestination.
        The `OCID`__ of the backup destination.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DistributedDbBackupDestination.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DistributedDbBackupDestination.
        The `OCID`__ of the backup destination.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DistributedDbBackupDestination.
        :type: str
        """
        self._id = id

    @property
    def vpc_user(self):
        """
        Gets the vpc_user of this DistributedDbBackupDestination.
        For a RECOVERY_APPLIANCE backup destination, the Virtual Private Catalog (VPC) user that is used to access the Recovery Appliance.


        :return: The vpc_user of this DistributedDbBackupDestination.
        :rtype: str
        """
        return self._vpc_user

    @vpc_user.setter
    def vpc_user(self, vpc_user):
        """
        Sets the vpc_user of this DistributedDbBackupDestination.
        For a RECOVERY_APPLIANCE backup destination, the Virtual Private Catalog (VPC) user that is used to access the Recovery Appliance.


        :param vpc_user: The vpc_user of this DistributedDbBackupDestination.
        :type: str
        """
        self._vpc_user = vpc_user

    @property
    def vpc_password(self):
        """
        Gets the vpc_password of this DistributedDbBackupDestination.
        For a RECOVERY_APPLIANCE backup destination, the password for the VPC user that is used to access the Recovery Appliance.


        :return: The vpc_password of this DistributedDbBackupDestination.
        :rtype: str
        """
        return self._vpc_password

    @vpc_password.setter
    def vpc_password(self, vpc_password):
        """
        Sets the vpc_password of this DistributedDbBackupDestination.
        For a RECOVERY_APPLIANCE backup destination, the password for the VPC user that is used to access the Recovery Appliance.


        :param vpc_password: The vpc_password of this DistributedDbBackupDestination.
        :type: str
        """
        self._vpc_password = vpc_password

    @property
    def is_zero_data_loss_enabled(self):
        """
        Gets the is_zero_data_loss_enabled of this DistributedDbBackupDestination.
        Indicates whether Zero Data Loss functionality is enabled for a Recovery Appliance backup destination in an Autonomous Container Database. When enabled, the database automatically ships all redo logs in real-time to the Recovery Appliance for a Zero Data Loss recovery setup (sub-second RPO). Defaults to `TRUE` if no value is given.


        :return: The is_zero_data_loss_enabled of this DistributedDbBackupDestination.
        :rtype: bool
        """
        return self._is_zero_data_loss_enabled

    @is_zero_data_loss_enabled.setter
    def is_zero_data_loss_enabled(self, is_zero_data_loss_enabled):
        """
        Sets the is_zero_data_loss_enabled of this DistributedDbBackupDestination.
        Indicates whether Zero Data Loss functionality is enabled for a Recovery Appliance backup destination in an Autonomous Container Database. When enabled, the database automatically ships all redo logs in real-time to the Recovery Appliance for a Zero Data Loss recovery setup (sub-second RPO). Defaults to `TRUE` if no value is given.


        :param is_zero_data_loss_enabled: The is_zero_data_loss_enabled of this DistributedDbBackupDestination.
        :type: bool
        """
        self._is_zero_data_loss_enabled = is_zero_data_loss_enabled

    @property
    def internet_proxy(self):
        """
        Gets the internet_proxy of this DistributedDbBackupDestination.
        Proxy URL to connect to object store.


        :return: The internet_proxy of this DistributedDbBackupDestination.
        :rtype: str
        """
        return self._internet_proxy

    @internet_proxy.setter
    def internet_proxy(self, internet_proxy):
        """
        Sets the internet_proxy of this DistributedDbBackupDestination.
        Proxy URL to connect to object store.


        :param internet_proxy: The internet_proxy of this DistributedDbBackupDestination.
        :type: str
        """
        self._internet_proxy = internet_proxy

    @property
    def dbrs_policy_id(self):
        """
        Gets the dbrs_policy_id of this DistributedDbBackupDestination.
        The `OCID`__ of the DBRS policy used for backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The dbrs_policy_id of this DistributedDbBackupDestination.
        :rtype: str
        """
        return self._dbrs_policy_id

    @dbrs_policy_id.setter
    def dbrs_policy_id(self, dbrs_policy_id):
        """
        Sets the dbrs_policy_id of this DistributedDbBackupDestination.
        The `OCID`__ of the DBRS policy used for backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param dbrs_policy_id: The dbrs_policy_id of this DistributedDbBackupDestination.
        :type: str
        """
        self._dbrs_policy_id = dbrs_policy_id

    @property
    def is_remote(self):
        """
        Gets the is_remote of this DistributedDbBackupDestination.
        Indicates whether the backup destination is cross-region or local region.


        :return: The is_remote of this DistributedDbBackupDestination.
        :rtype: bool
        """
        return self._is_remote

    @is_remote.setter
    def is_remote(self, is_remote):
        """
        Sets the is_remote of this DistributedDbBackupDestination.
        Indicates whether the backup destination is cross-region or local region.


        :param is_remote: The is_remote of this DistributedDbBackupDestination.
        :type: bool
        """
        self._is_remote = is_remote

    @property
    def remote_region(self):
        """
        Gets the remote_region of this DistributedDbBackupDestination.
        The name of the remote region where the remote automatic incremental backups will be stored.
        For information about valid region names, see
        `Regions and Availability Domains`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/regions.htm


        :return: The remote_region of this DistributedDbBackupDestination.
        :rtype: str
        """
        return self._remote_region

    @remote_region.setter
    def remote_region(self, remote_region):
        """
        Sets the remote_region of this DistributedDbBackupDestination.
        The name of the remote region where the remote automatic incremental backups will be stored.
        For information about valid region names, see
        `Regions and Availability Domains`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/regions.htm


        :param remote_region: The remote_region of this DistributedDbBackupDestination.
        :type: str
        """
        self._remote_region = remote_region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
