# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDistributedAutonomousDatabaseCatalogDetails(object):
    """
    Details of the Globally distributed autonomous database catalog.
    """

    #: A constant which can be used with the source property of a CreateDistributedAutonomousDatabaseCatalogDetails.
    #: This constant has a value of "ADB_D"
    SOURCE_ADB_D = "ADB_D"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDistributedAutonomousDatabaseCatalogDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.distributed_database.models.CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this CreateDistributedAutonomousDatabaseCatalogDetails.
            Allowed values for this property are: "ADB_D"
        :type source: str

        """
        self.swagger_types = {
            'source': 'str'
        }
        self.attribute_map = {
            'source': 'source'
        }
        self._source = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['source']

        if type == 'ADB_D':
            return 'CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails'
        else:
            return 'CreateDistributedAutonomousDatabaseCatalogDetails'

    @property
    def source(self):
        """
        **[Required]** Gets the source of this CreateDistributedAutonomousDatabaseCatalogDetails.
        The source of Globally distributed autonomous database type: Use ADB_D for the Globally distributed autonomous database with
        autonomous dedicated cloudautonomousvmclusters.

        Allowed values for this property are: "ADB_D"


        :return: The source of this CreateDistributedAutonomousDatabaseCatalogDetails.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this CreateDistributedAutonomousDatabaseCatalogDetails.
        The source of Globally distributed autonomous database type: Use ADB_D for the Globally distributed autonomous database with
        autonomous dedicated cloudautonomousvmclusters.


        :param source: The source of this CreateDistributedAutonomousDatabaseCatalogDetails.
        :type: str
        """
        allowed_values = ["ADB_D"]
        if not value_allowed_none_or_none_sentinel(source, allowed_values):
            raise ValueError(
                f"Invalid value for `source`, must be None or one of {allowed_values}"
            )
        self._source = source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
