# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateStackDetails(object):
    """
    Details to update a Stack.
    """

    #: A constant which can be used with the stack_templates property of a UpdateStackDetails.
    #: This constant has a value of "DATALAKE"
    STACK_TEMPLATES_DATALAKE = "DATALAKE"

    #: A constant which can be used with the stack_templates property of a UpdateStackDetails.
    #: This constant has a value of "DATAPIPELINE"
    STACK_TEMPLATES_DATAPIPELINE = "DATAPIPELINE"

    #: A constant which can be used with the stack_templates property of a UpdateStackDetails.
    #: This constant has a value of "AISERVICES"
    STACK_TEMPLATES_AISERVICES = "AISERVICES"

    #: A constant which can be used with the stack_templates property of a UpdateStackDetails.
    #: This constant has a value of "DATATRANSFORMATION"
    STACK_TEMPLATES_DATATRANSFORMATION = "DATATRANSFORMATION"

    #: A constant which can be used with the stack_templates property of a UpdateStackDetails.
    #: This constant has a value of "DEVOPSTOOLKIT"
    STACK_TEMPLATES_DEVOPSTOOLKIT = "DEVOPSTOOLKIT"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "ADB"
    SERVICES_ADB = "ADB"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "GGCS"
    SERVICES_GGCS = "GGCS"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "OBJECTSTORAGE"
    SERVICES_OBJECTSTORAGE = "OBJECTSTORAGE"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "GENAI"
    SERVICES_GENAI = "GENAI"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "DATAFLOW"
    SERVICES_DATAFLOW = "DATAFLOW"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "AIDATAPLATFORM"
    SERVICES_AIDATAPLATFORM = "AIDATAPLATFORM"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "OMK"
    SERVICES_OMK = "OMK"

    #: A constant which can be used with the services property of a UpdateStackDetails.
    #: This constant has a value of "OKE"
    SERVICES_OKE = "OKE"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateStackDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param notification_email:
            The value to assign to the notification_email property of this UpdateStackDetails.
        :type notification_email: str

        :param stack_templates:
            The value to assign to the stack_templates property of this UpdateStackDetails.
            Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION", "DEVOPSTOOLKIT"
        :type stack_templates: list[str]

        :param services:
            The value to assign to the services property of this UpdateStackDetails.
            Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW", "AIDATAPLATFORM", "OMK", "OKE"
        :type services: list[str]

        :param adb:
            The value to assign to the adb property of this UpdateStackDetails.
        :type adb: list[oci.dif.models.AdbUpdateDetail]

        :param ggcs:
            The value to assign to the ggcs property of this UpdateStackDetails.
        :type ggcs: list[oci.dif.models.GgcsUpdateDetail]

        :param dataflow:
            The value to assign to the dataflow property of this UpdateStackDetails.
        :type dataflow: list[oci.dif.models.DataflowUpdateDetail]

        :param objectstorage:
            The value to assign to the objectstorage property of this UpdateStackDetails.
        :type objectstorage: list[oci.dif.models.ObjectStorageUpdateDetail]

        :param genai:
            The value to assign to the genai property of this UpdateStackDetails.
        :type genai: list[oci.dif.models.GenAiUpdateDetail]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateStackDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateStackDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'notification_email': 'str',
            'stack_templates': 'list[str]',
            'services': 'list[str]',
            'adb': 'list[AdbUpdateDetail]',
            'ggcs': 'list[GgcsUpdateDetail]',
            'dataflow': 'list[DataflowUpdateDetail]',
            'objectstorage': 'list[ObjectStorageUpdateDetail]',
            'genai': 'list[GenAiUpdateDetail]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'notification_email': 'notificationEmail',
            'stack_templates': 'stackTemplates',
            'services': 'services',
            'adb': 'adb',
            'ggcs': 'ggcs',
            'dataflow': 'dataflow',
            'objectstorage': 'objectstorage',
            'genai': 'genai',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._notification_email = None
        self._stack_templates = None
        self._services = None
        self._adb = None
        self._ggcs = None
        self._dataflow = None
        self._objectstorage = None
        self._genai = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def notification_email(self):
        """
        Gets the notification_email of this UpdateStackDetails.
        email id to which the stack notifications would be sent.


        :return: The notification_email of this UpdateStackDetails.
        :rtype: str
        """
        return self._notification_email

    @notification_email.setter
    def notification_email(self, notification_email):
        """
        Sets the notification_email of this UpdateStackDetails.
        email id to which the stack notifications would be sent.


        :param notification_email: The notification_email of this UpdateStackDetails.
        :type: str
        """
        self._notification_email = notification_email

    @property
    def stack_templates(self):
        """
        Gets the stack_templates of this UpdateStackDetails.
        List of templates to be updated for the stack.

        Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION", "DEVOPSTOOLKIT"


        :return: The stack_templates of this UpdateStackDetails.
        :rtype: list[str]
        """
        return self._stack_templates

    @stack_templates.setter
    def stack_templates(self, stack_templates):
        """
        Sets the stack_templates of this UpdateStackDetails.
        List of templates to be updated for the stack.


        :param stack_templates: The stack_templates of this UpdateStackDetails.
        :type: list[str]
        """
        allowed_values = ["DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION", "DEVOPSTOOLKIT"]

        if stack_templates and stack_templates is not NONE_SENTINEL:
            for value in stack_templates:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `stack_templates`, must be None or one of {allowed_values}"
                    )
        self._stack_templates = stack_templates

    @property
    def services(self):
        """
        Gets the services of this UpdateStackDetails.
        List of services to be updated for the stack.

        Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW", "AIDATAPLATFORM", "OMK", "OKE"


        :return: The services of this UpdateStackDetails.
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this UpdateStackDetails.
        List of services to be updated for the stack.


        :param services: The services of this UpdateStackDetails.
        :type: list[str]
        """
        allowed_values = ["ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW", "AIDATAPLATFORM", "OMK", "OKE"]

        if services and services is not NONE_SENTINEL:
            for value in services:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `services`, must be None or one of {allowed_values}"
                    )
        self._services = services

    @property
    def adb(self):
        """
        Gets the adb of this UpdateStackDetails.
        ADB details if adb is included in the services to be updated.


        :return: The adb of this UpdateStackDetails.
        :rtype: list[oci.dif.models.AdbUpdateDetail]
        """
        return self._adb

    @adb.setter
    def adb(self, adb):
        """
        Sets the adb of this UpdateStackDetails.
        ADB details if adb is included in the services to be updated.


        :param adb: The adb of this UpdateStackDetails.
        :type: list[oci.dif.models.AdbUpdateDetail]
        """
        self._adb = adb

    @property
    def ggcs(self):
        """
        Gets the ggcs of this UpdateStackDetails.
        GGCS details if ggcs is included in the services to be updated.


        :return: The ggcs of this UpdateStackDetails.
        :rtype: list[oci.dif.models.GgcsUpdateDetail]
        """
        return self._ggcs

    @ggcs.setter
    def ggcs(self, ggcs):
        """
        Sets the ggcs of this UpdateStackDetails.
        GGCS details if ggcs is included in the services to be updated.


        :param ggcs: The ggcs of this UpdateStackDetails.
        :type: list[oci.dif.models.GgcsUpdateDetail]
        """
        self._ggcs = ggcs

    @property
    def dataflow(self):
        """
        Gets the dataflow of this UpdateStackDetails.
        DATAFLOW details if dataflow is included in the services to be updated.


        :return: The dataflow of this UpdateStackDetails.
        :rtype: list[oci.dif.models.DataflowUpdateDetail]
        """
        return self._dataflow

    @dataflow.setter
    def dataflow(self, dataflow):
        """
        Sets the dataflow of this UpdateStackDetails.
        DATAFLOW details if dataflow is included in the services to be updated.


        :param dataflow: The dataflow of this UpdateStackDetails.
        :type: list[oci.dif.models.DataflowUpdateDetail]
        """
        self._dataflow = dataflow

    @property
    def objectstorage(self):
        """
        Gets the objectstorage of this UpdateStackDetails.
        Object Storage Details if object storage is included in services to be updated.


        :return: The objectstorage of this UpdateStackDetails.
        :rtype: list[oci.dif.models.ObjectStorageUpdateDetail]
        """
        return self._objectstorage

    @objectstorage.setter
    def objectstorage(self, objectstorage):
        """
        Sets the objectstorage of this UpdateStackDetails.
        Object Storage Details if object storage is included in services to be updated.


        :param objectstorage: The objectstorage of this UpdateStackDetails.
        :type: list[oci.dif.models.ObjectStorageUpdateDetail]
        """
        self._objectstorage = objectstorage

    @property
    def genai(self):
        """
        Gets the genai of this UpdateStackDetails.
        GenAI Details if genai is included in services to be updated.


        :return: The genai of this UpdateStackDetails.
        :rtype: list[oci.dif.models.GenAiUpdateDetail]
        """
        return self._genai

    @genai.setter
    def genai(self, genai):
        """
        Sets the genai of this UpdateStackDetails.
        GenAI Details if genai is included in services to be updated.


        :param genai: The genai of this UpdateStackDetails.
        :type: list[oci.dif.models.GenAiUpdateDetail]
        """
        self._genai = genai

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateStackDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateStackDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateStackDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateStackDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateStackDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateStackDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateStackDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateStackDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
