# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityAuditSummary(object):
    """
    Summary of vulnerability audit.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityAuditSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vulnerability_audit_id:
            The value to assign to the vulnerability_audit_id property of this VulnerabilityAuditSummary.
        :type vulnerability_audit_id: str

        :param commit_hash:
            The value to assign to the commit_hash property of this VulnerabilityAuditSummary.
        :type commit_hash: str

        :param build_stage_id:
            The value to assign to the build_stage_id property of this VulnerabilityAuditSummary.
        :type build_stage_id: str

        """
        self.swagger_types = {
            'vulnerability_audit_id': 'str',
            'commit_hash': 'str',
            'build_stage_id': 'str'
        }
        self.attribute_map = {
            'vulnerability_audit_id': 'vulnerabilityAuditId',
            'commit_hash': 'commitHash',
            'build_stage_id': 'buildStageId'
        }
        self._vulnerability_audit_id = None
        self._commit_hash = None
        self._build_stage_id = None

    @property
    def vulnerability_audit_id(self):
        """
        **[Required]** Gets the vulnerability_audit_id of this VulnerabilityAuditSummary.
        The OCID of the vulnerability audit.


        :return: The vulnerability_audit_id of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._vulnerability_audit_id

    @vulnerability_audit_id.setter
    def vulnerability_audit_id(self, vulnerability_audit_id):
        """
        Sets the vulnerability_audit_id of this VulnerabilityAuditSummary.
        The OCID of the vulnerability audit.


        :param vulnerability_audit_id: The vulnerability_audit_id of this VulnerabilityAuditSummary.
        :type: str
        """
        self._vulnerability_audit_id = vulnerability_audit_id

    @property
    def commit_hash(self):
        """
        Gets the commit_hash of this VulnerabilityAuditSummary.
        Commit hash used while retrieving the pom file for vulnerabilityAudit.


        :return: The commit_hash of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._commit_hash

    @commit_hash.setter
    def commit_hash(self, commit_hash):
        """
        Sets the commit_hash of this VulnerabilityAuditSummary.
        Commit hash used while retrieving the pom file for vulnerabilityAudit.


        :param commit_hash: The commit_hash of this VulnerabilityAuditSummary.
        :type: str
        """
        self._commit_hash = commit_hash

    @property
    def build_stage_id(self):
        """
        **[Required]** Gets the build_stage_id of this VulnerabilityAuditSummary.
        Build stage OCID where scan was configured.


        :return: The build_stage_id of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._build_stage_id

    @build_stage_id.setter
    def build_stage_id(self, build_stage_id):
        """
        Sets the build_stage_id of this VulnerabilityAuditSummary.
        Build stage OCID where scan was configured.


        :param build_stage_id: The build_stage_id of this VulnerabilityAuditSummary.
        :type: str
        """
        self._build_stage_id = build_stage_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
