# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .pull_request_activity_summary import PullRequestActivitySummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CommentActivitySummary(PullRequestActivitySummary):
    """
    activity describing comment addition to a pull request
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CommentActivitySummary object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.CommentActivitySummary.activity_type` attribute
        of this class is ``COMMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CommentActivitySummary.
        :type id: str

        :param principal:
            The value to assign to the principal property of this CommentActivitySummary.
        :type principal: oci.devops.models.PrincipalDetails

        :param pull_request_id:
            The value to assign to the pull_request_id property of this CommentActivitySummary.
        :type pull_request_id: str

        :param time_occurred:
            The value to assign to the time_occurred property of this CommentActivitySummary.
        :type time_occurred: datetime

        :param activity_type:
            The value to assign to the activity_type property of this CommentActivitySummary.
            Allowed values for this property are: "LIFECYCLE", "APPROVAL", "COMMIT", "REVIEWER", "COMMENT"
        :type activity_type: str

        :param comment_id:
            The value to assign to the comment_id property of this CommentActivitySummary.
        :type comment_id: str

        """
        self.swagger_types = {
            'id': 'str',
            'principal': 'PrincipalDetails',
            'pull_request_id': 'str',
            'time_occurred': 'datetime',
            'activity_type': 'str',
            'comment_id': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'principal': 'principal',
            'pull_request_id': 'pullRequestId',
            'time_occurred': 'timeOccurred',
            'activity_type': 'activityType',
            'comment_id': 'commentId'
        }
        self._id = None
        self._principal = None
        self._pull_request_id = None
        self._time_occurred = None
        self._activity_type = None
        self._comment_id = None
        self._activity_type = 'COMMENT'

    @property
    def comment_id(self):
        """
        **[Required]** Gets the comment_id of this CommentActivitySummary.
        Identifier of comment added to a PR


        :return: The comment_id of this CommentActivitySummary.
        :rtype: str
        """
        return self._comment_id

    @comment_id.setter
    def comment_id(self, comment_id):
        """
        Sets the comment_id of this CommentActivitySummary.
        Identifier of comment added to a PR


        :param comment_id: The comment_id of this CommentActivitySummary.
        :type: str
        """
        self._comment_id = comment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
