# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220618


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DesktopConnection(object):
    """
    Provides information about a connection to a desktop, including connect and disconnect time, and client properties.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DesktopConnection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_connected:
            The value to assign to the time_connected property of this DesktopConnection.
        :type time_connected: datetime

        :param time_disconnected:
            The value to assign to the time_disconnected property of this DesktopConnection.
        :type time_disconnected: datetime

        :param next_action:
            The value to assign to the next_action property of this DesktopConnection.
        :type next_action: oci.desktops.models.DesktopAction

        :param last_action:
            The value to assign to the last_action property of this DesktopConnection.
        :type last_action: oci.desktops.models.DesktopAction

        :param client_type:
            The value to assign to the client_type property of this DesktopConnection.
        :type client_type: str

        :param client_version:
            The value to assign to the client_version property of this DesktopConnection.
        :type client_version: str

        :param client_platform:
            The value to assign to the client_platform property of this DesktopConnection.
        :type client_platform: str

        """
        self.swagger_types = {
            'time_connected': 'datetime',
            'time_disconnected': 'datetime',
            'next_action': 'DesktopAction',
            'last_action': 'DesktopAction',
            'client_type': 'str',
            'client_version': 'str',
            'client_platform': 'str'
        }
        self.attribute_map = {
            'time_connected': 'timeConnected',
            'time_disconnected': 'timeDisconnected',
            'next_action': 'nextAction',
            'last_action': 'lastAction',
            'client_type': 'clientType',
            'client_version': 'clientVersion',
            'client_platform': 'clientPlatform'
        }
        self._time_connected = None
        self._time_disconnected = None
        self._next_action = None
        self._last_action = None
        self._client_type = None
        self._client_version = None
        self._client_platform = None

    @property
    def time_connected(self):
        """
        Gets the time_connected of this DesktopConnection.
        The time when the last connection to a desktop started.


        :return: The time_connected of this DesktopConnection.
        :rtype: datetime
        """
        return self._time_connected

    @time_connected.setter
    def time_connected(self, time_connected):
        """
        Sets the time_connected of this DesktopConnection.
        The time when the last connection to a desktop started.


        :param time_connected: The time_connected of this DesktopConnection.
        :type: datetime
        """
        self._time_connected = time_connected

    @property
    def time_disconnected(self):
        """
        Gets the time_disconnected of this DesktopConnection.
        The time when the last connection to a desktop ended.


        :return: The time_disconnected of this DesktopConnection.
        :rtype: datetime
        """
        return self._time_disconnected

    @time_disconnected.setter
    def time_disconnected(self, time_disconnected):
        """
        Sets the time_disconnected of this DesktopConnection.
        The time when the last connection to a desktop ended.


        :param time_disconnected: The time_disconnected of this DesktopConnection.
        :type: datetime
        """
        self._time_disconnected = time_disconnected

    @property
    def next_action(self):
        """
        Gets the next_action of this DesktopConnection.

        :return: The next_action of this DesktopConnection.
        :rtype: oci.desktops.models.DesktopAction
        """
        return self._next_action

    @next_action.setter
    def next_action(self, next_action):
        """
        Sets the next_action of this DesktopConnection.

        :param next_action: The next_action of this DesktopConnection.
        :type: oci.desktops.models.DesktopAction
        """
        self._next_action = next_action

    @property
    def last_action(self):
        """
        Gets the last_action of this DesktopConnection.

        :return: The last_action of this DesktopConnection.
        :rtype: oci.desktops.models.DesktopAction
        """
        return self._last_action

    @last_action.setter
    def last_action(self, last_action):
        """
        Sets the last_action of this DesktopConnection.

        :param last_action: The last_action of this DesktopConnection.
        :type: oci.desktops.models.DesktopAction
        """
        self._last_action = last_action

    @property
    def client_type(self):
        """
        Gets the client_type of this DesktopConnection.
        The type of Secure Desktops client connected to a desktop.


        :return: The client_type of this DesktopConnection.
        :rtype: str
        """
        return self._client_type

    @client_type.setter
    def client_type(self, client_type):
        """
        Sets the client_type of this DesktopConnection.
        The type of Secure Desktops client connected to a desktop.


        :param client_type: The client_type of this DesktopConnection.
        :type: str
        """
        self._client_type = client_type

    @property
    def client_version(self):
        """
        Gets the client_version of this DesktopConnection.
        The version of the Secure Desktops client connected to a desktop, applicable only to the installed client type.


        :return: The client_version of this DesktopConnection.
        :rtype: str
        """
        return self._client_version

    @client_version.setter
    def client_version(self, client_version):
        """
        Sets the client_version of this DesktopConnection.
        The version of the Secure Desktops client connected to a desktop, applicable only to the installed client type.


        :param client_version: The client_version of this DesktopConnection.
        :type: str
        """
        self._client_version = client_version

    @property
    def client_platform(self):
        """
        Gets the client_platform of this DesktopConnection.
        The platform on which the Secure Desktops client runs.


        :return: The client_platform of this DesktopConnection.
        :rtype: str
        """
        return self._client_platform

    @client_platform.setter
    def client_platform(self, client_platform):
        """
        Sets the client_platform of this DesktopConnection.
        The platform on which the Secure Desktops client runs.


        :param client_platform: The client_platform of this DesktopConnection.
        :type: str
        """
        self._client_platform = client_platform

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
