# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DelegatedResourceAccessRequestHistorySummary(object):
    """
    Summary of Delegated Resource Access Request status changes.
    """

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "CREATED"
    REQUEST_STATUS_CREATED = "CREATED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "APPROVAL_WAITING"
    REQUEST_STATUS_APPROVAL_WAITING = "APPROVAL_WAITING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "OPERATOR_ASSIGNMENT_WAITING"
    REQUEST_STATUS_OPERATOR_ASSIGNMENT_WAITING = "OPERATOR_ASSIGNMENT_WAITING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "PREAPPROVED"
    REQUEST_STATUS_PREAPPROVED = "PREAPPROVED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "APPROVED"
    REQUEST_STATUS_APPROVED = "APPROVED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "APPROVED_FOR_FUTURE"
    REQUEST_STATUS_APPROVED_FOR_FUTURE = "APPROVED_FOR_FUTURE"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "REJECTED"
    REQUEST_STATUS_REJECTED = "REJECTED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "DEPLOYED"
    REQUEST_STATUS_DEPLOYED = "DEPLOYED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "DEPLOY_FAILED"
    REQUEST_STATUS_DEPLOY_FAILED = "DEPLOY_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "UNDEPLOYED"
    REQUEST_STATUS_UNDEPLOYED = "UNDEPLOYED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "UNDEPLOY_FAILED"
    REQUEST_STATUS_UNDEPLOY_FAILED = "UNDEPLOY_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "CLOSE_FAILED"
    REQUEST_STATUS_CLOSE_FAILED = "CLOSE_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "REVOKE_FAILED"
    REQUEST_STATUS_REVOKE_FAILED = "REVOKE_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "EXPIRY_FAILED"
    REQUEST_STATUS_EXPIRY_FAILED = "EXPIRY_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "REVOKING"
    REQUEST_STATUS_REVOKING = "REVOKING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "REVOKED"
    REQUEST_STATUS_REVOKED = "REVOKED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "EXTENDING"
    REQUEST_STATUS_EXTENDING = "EXTENDING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "EXTENDED"
    REQUEST_STATUS_EXTENDED = "EXTENDED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "EXTENSION_REJECTED"
    REQUEST_STATUS_EXTENSION_REJECTED = "EXTENSION_REJECTED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "EXTENSION_FAILED"
    REQUEST_STATUS_EXTENSION_FAILED = "EXTENSION_FAILED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "COMPLETING"
    REQUEST_STATUS_COMPLETING = "COMPLETING"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "COMPLETED"
    REQUEST_STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the request_status property of a DelegatedResourceAccessRequestHistorySummary.
    #: This constant has a value of "EXPIRED"
    REQUEST_STATUS_EXPIRED = "EXPIRED"

    def __init__(self, **kwargs):
        """
        Initializes a new DelegatedResourceAccessRequestHistorySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DelegatedResourceAccessRequestHistorySummary.
        :type lifecycle_state: str

        :param request_status:
            The value to assign to the request_status property of this DelegatedResourceAccessRequestHistorySummary.
            Allowed values for this property are: "CREATED", "APPROVAL_WAITING", "OPERATOR_ASSIGNMENT_WAITING", "PREAPPROVED", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "UNDEPLOYED", "UNDEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "EXTENDING", "EXTENDED", "EXTENSION_REJECTED", "EXTENSION_FAILED", "COMPLETING", "COMPLETED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type request_status: str

        :param user_id:
            The value to assign to the user_id property of this DelegatedResourceAccessRequestHistorySummary.
        :type user_id: str

        :param comment:
            The value to assign to the comment property of this DelegatedResourceAccessRequestHistorySummary.
        :type comment: str

        :param timestamp:
            The value to assign to the timestamp property of this DelegatedResourceAccessRequestHistorySummary.
        :type timestamp: datetime

        """
        self.swagger_types = {
            'lifecycle_state': 'str',
            'request_status': 'str',
            'user_id': 'str',
            'comment': 'str',
            'timestamp': 'datetime'
        }
        self.attribute_map = {
            'lifecycle_state': 'lifecycleState',
            'request_status': 'requestStatus',
            'user_id': 'userId',
            'comment': 'comment',
            'timestamp': 'timestamp'
        }
        self._lifecycle_state = None
        self._request_status = None
        self._user_id = None
        self._comment = None
        self._timestamp = None

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this DelegatedResourceAccessRequestHistorySummary.
        The current lifecycle state of the Delegated Resource Access Request.


        :return: The lifecycle_state of this DelegatedResourceAccessRequestHistorySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DelegatedResourceAccessRequestHistorySummary.
        The current lifecycle state of the Delegated Resource Access Request.


        :param lifecycle_state: The lifecycle_state of this DelegatedResourceAccessRequestHistorySummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def request_status(self):
        """
        Gets the request_status of this DelegatedResourceAccessRequestHistorySummary.
        The current status of the Delegated Resource Access Request.

        Allowed values for this property are: "CREATED", "APPROVAL_WAITING", "OPERATOR_ASSIGNMENT_WAITING", "PREAPPROVED", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "UNDEPLOYED", "UNDEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "EXTENDING", "EXTENDED", "EXTENSION_REJECTED", "EXTENSION_FAILED", "COMPLETING", "COMPLETED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The request_status of this DelegatedResourceAccessRequestHistorySummary.
        :rtype: str
        """
        return self._request_status

    @request_status.setter
    def request_status(self, request_status):
        """
        Sets the request_status of this DelegatedResourceAccessRequestHistorySummary.
        The current status of the Delegated Resource Access Request.


        :param request_status: The request_status of this DelegatedResourceAccessRequestHistorySummary.
        :type: str
        """
        allowed_values = ["CREATED", "APPROVAL_WAITING", "OPERATOR_ASSIGNMENT_WAITING", "PREAPPROVED", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "UNDEPLOYED", "UNDEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "EXTENDING", "EXTENDED", "EXTENSION_REJECTED", "EXTENSION_FAILED", "COMPLETING", "COMPLETED", "EXPIRED"]
        if not value_allowed_none_or_none_sentinel(request_status, allowed_values):
            request_status = 'UNKNOWN_ENUM_VALUE'
        self._request_status = request_status

    @property
    def user_id(self):
        """
        Gets the user_id of this DelegatedResourceAccessRequestHistorySummary.
        ID of user who modified the Delegated Resource Access Request. For operator, this field is \"Operator\".


        :return: The user_id of this DelegatedResourceAccessRequestHistorySummary.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this DelegatedResourceAccessRequestHistorySummary.
        ID of user who modified the Delegated Resource Access Request. For operator, this field is \"Operator\".


        :param user_id: The user_id of this DelegatedResourceAccessRequestHistorySummary.
        :type: str
        """
        self._user_id = user_id

    @property
    def comment(self):
        """
        Gets the comment of this DelegatedResourceAccessRequestHistorySummary.
        Comment about the status change.


        :return: The comment of this DelegatedResourceAccessRequestHistorySummary.
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """
        Sets the comment of this DelegatedResourceAccessRequestHistorySummary.
        Comment about the status change.


        :param comment: The comment of this DelegatedResourceAccessRequestHistorySummary.
        :type: str
        """
        self._comment = comment

    @property
    def timestamp(self):
        """
        Gets the timestamp of this DelegatedResourceAccessRequestHistorySummary.
        Time when the respective action happened in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The timestamp of this DelegatedResourceAccessRequestHistorySummary.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this DelegatedResourceAccessRequestHistorySummary.
        Time when the respective action happened in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param timestamp: The timestamp of this DelegatedResourceAccessRequestHistorySummary.
        :type: datetime
        """
        self._timestamp = timestamp

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
