# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceRoleDetails(object):
    """
    Service Role details object.
    """

    #: A constant which can be used with the service_type property of a ServiceRoleDetails.
    #: This constant has a value of "KMS"
    SERVICE_TYPE_KMS = "KMS"

    #: A constant which can be used with the assume_role_status property of a ServiceRoleDetails.
    #: This constant has a value of "CONNECTED"
    ASSUME_ROLE_STATUS_CONNECTED = "CONNECTED"

    #: A constant which can be used with the assume_role_status property of a ServiceRoleDetails.
    #: This constant has a value of "DISCONNECTED"
    ASSUME_ROLE_STATUS_DISCONNECTED = "DISCONNECTED"

    #: A constant which can be used with the assume_role_status property of a ServiceRoleDetails.
    #: This constant has a value of "PARTIALLY_CONNECTED"
    ASSUME_ROLE_STATUS_PARTIALLY_CONNECTED = "PARTIALLY_CONNECTED"

    #: A constant which can be used with the assume_role_status property of a ServiceRoleDetails.
    #: This constant has a value of "UNKNOWN"
    ASSUME_ROLE_STATUS_UNKNOWN = "UNKNOWN"

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceRoleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param role_arn:
            The value to assign to the role_arn property of this ServiceRoleDetails.
        :type role_arn: str

        :param service_private_endpoint:
            The value to assign to the service_private_endpoint property of this ServiceRoleDetails.
        :type service_private_endpoint: str

        :param service_type:
            The value to assign to the service_type property of this ServiceRoleDetails.
            Allowed values for this property are: "KMS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_type: str

        :param assume_role_status:
            The value to assign to the assume_role_status property of this ServiceRoleDetails.
            Allowed values for this property are: "CONNECTED", "DISCONNECTED", "PARTIALLY_CONNECTED", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type assume_role_status: str

        :param aws_nodes:
            The value to assign to the aws_nodes property of this ServiceRoleDetails.
        :type aws_nodes: list[oci.dbmulticloud.models.AwsNodes]

        """
        self.swagger_types = {
            'role_arn': 'str',
            'service_private_endpoint': 'str',
            'service_type': 'str',
            'assume_role_status': 'str',
            'aws_nodes': 'list[AwsNodes]'
        }
        self.attribute_map = {
            'role_arn': 'roleArn',
            'service_private_endpoint': 'servicePrivateEndpoint',
            'service_type': 'serviceType',
            'assume_role_status': 'assumeRoleStatus',
            'aws_nodes': 'awsNodes'
        }
        self._role_arn = None
        self._service_private_endpoint = None
        self._service_type = None
        self._assume_role_status = None
        self._aws_nodes = None

    @property
    def role_arn(self):
        """
        **[Required]** Gets the role_arn of this ServiceRoleDetails.
        Amazon resource name AWSof the IAM role.


        :return: The role_arn of this ServiceRoleDetails.
        :rtype: str
        """
        return self._role_arn

    @role_arn.setter
    def role_arn(self, role_arn):
        """
        Sets the role_arn of this ServiceRoleDetails.
        Amazon resource name AWSof the IAM role.


        :param role_arn: The role_arn of this ServiceRoleDetails.
        :type: str
        """
        self._role_arn = role_arn

    @property
    def service_private_endpoint(self):
        """
        **[Required]** Gets the service_private_endpoint of this ServiceRoleDetails.
        Private endpoint of the AWS service.


        :return: The service_private_endpoint of this ServiceRoleDetails.
        :rtype: str
        """
        return self._service_private_endpoint

    @service_private_endpoint.setter
    def service_private_endpoint(self, service_private_endpoint):
        """
        Sets the service_private_endpoint of this ServiceRoleDetails.
        Private endpoint of the AWS service.


        :param service_private_endpoint: The service_private_endpoint of this ServiceRoleDetails.
        :type: str
        """
        self._service_private_endpoint = service_private_endpoint

    @property
    def service_type(self):
        """
        **[Required]** Gets the service_type of this ServiceRoleDetails.
        Type of service.

        Allowed values for this property are: "KMS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The service_type of this ServiceRoleDetails.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this ServiceRoleDetails.
        Type of service.


        :param service_type: The service_type of this ServiceRoleDetails.
        :type: str
        """
        allowed_values = ["KMS"]
        if not value_allowed_none_or_none_sentinel(service_type, allowed_values):
            service_type = 'UNKNOWN_ENUM_VALUE'
        self._service_type = service_type

    @property
    def assume_role_status(self):
        """
        Gets the assume_role_status of this ServiceRoleDetails.
        Assume role  status.

        Allowed values for this property are: "CONNECTED", "DISCONNECTED", "PARTIALLY_CONNECTED", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The assume_role_status of this ServiceRoleDetails.
        :rtype: str
        """
        return self._assume_role_status

    @assume_role_status.setter
    def assume_role_status(self, assume_role_status):
        """
        Sets the assume_role_status of this ServiceRoleDetails.
        Assume role  status.


        :param assume_role_status: The assume_role_status of this ServiceRoleDetails.
        :type: str
        """
        allowed_values = ["CONNECTED", "DISCONNECTED", "PARTIALLY_CONNECTED", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(assume_role_status, allowed_values):
            assume_role_status = 'UNKNOWN_ENUM_VALUE'
        self._assume_role_status = assume_role_status

    @property
    def aws_nodes(self):
        """
        Gets the aws_nodes of this ServiceRoleDetails.
        List of all VMs where AWS Identity Connector is configured for Oracle DB Cloud VM Cluster.


        :return: The aws_nodes of this ServiceRoleDetails.
        :rtype: list[oci.dbmulticloud.models.AwsNodes]
        """
        return self._aws_nodes

    @aws_nodes.setter
    def aws_nodes(self, aws_nodes):
        """
        Sets the aws_nodes of this ServiceRoleDetails.
        List of all VMs where AWS Identity Connector is configured for Oracle DB Cloud VM Cluster.


        :param aws_nodes: The aws_nodes of this ServiceRoleDetails.
        :type: list[oci.dbmulticloud.models.AwsNodes]
        """
        self._aws_nodes = aws_nodes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
