# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleDbAzureConnectorSummary(object):
    """
    Details of Oracle DB Azure Connector resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OracleDbAzureConnectorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleDbAzureConnectorSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleDbAzureConnectorSummary.
        :type compartment_id: str

        :param db_cluster_resource_id:
            The value to assign to the db_cluster_resource_id property of this OracleDbAzureConnectorSummary.
        :type db_cluster_resource_id: str

        :param display_name:
            The value to assign to the display_name property of this OracleDbAzureConnectorSummary.
        :type display_name: str

        :param arc_agent_nodes:
            The value to assign to the arc_agent_nodes property of this OracleDbAzureConnectorSummary.
        :type arc_agent_nodes: list[oci.dbmulticloud.models.ArcAgentNodes]

        :param azure_tenant_id:
            The value to assign to the azure_tenant_id property of this OracleDbAzureConnectorSummary.
        :type azure_tenant_id: str

        :param azure_subscription_id:
            The value to assign to the azure_subscription_id property of this OracleDbAzureConnectorSummary.
        :type azure_subscription_id: str

        :param azure_resource_group:
            The value to assign to the azure_resource_group property of this OracleDbAzureConnectorSummary.
        :type azure_resource_group: str

        :param private_endpoint_ip_address:
            The value to assign to the private_endpoint_ip_address property of this OracleDbAzureConnectorSummary.
        :type private_endpoint_ip_address: str

        :param private_endpoint_dns_alias:
            The value to assign to the private_endpoint_dns_alias property of this OracleDbAzureConnectorSummary.
        :type private_endpoint_dns_alias: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleDbAzureConnectorSummary.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this OracleDbAzureConnectorSummary.
        :type lifecycle_state_details: str

        :param azure_identity_mechanism:
            The value to assign to the azure_identity_mechanism property of this OracleDbAzureConnectorSummary.
        :type azure_identity_mechanism: str

        :param azure_identity_connectivity_status:
            The value to assign to the azure_identity_connectivity_status property of this OracleDbAzureConnectorSummary.
        :type azure_identity_connectivity_status: str

        :param time_created:
            The value to assign to the time_created property of this OracleDbAzureConnectorSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleDbAzureConnectorSummary.
        :type time_updated: datetime

        :param last_modification:
            The value to assign to the last_modification property of this OracleDbAzureConnectorSummary.
        :type last_modification: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleDbAzureConnectorSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleDbAzureConnectorSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleDbAzureConnectorSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'db_cluster_resource_id': 'str',
            'display_name': 'str',
            'arc_agent_nodes': 'list[ArcAgentNodes]',
            'azure_tenant_id': 'str',
            'azure_subscription_id': 'str',
            'azure_resource_group': 'str',
            'private_endpoint_ip_address': 'str',
            'private_endpoint_dns_alias': 'str',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'azure_identity_mechanism': 'str',
            'azure_identity_connectivity_status': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'last_modification': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'db_cluster_resource_id': 'dbClusterResourceId',
            'display_name': 'displayName',
            'arc_agent_nodes': 'arcAgentNodes',
            'azure_tenant_id': 'azureTenantId',
            'azure_subscription_id': 'azureSubscriptionId',
            'azure_resource_group': 'azureResourceGroup',
            'private_endpoint_ip_address': 'privateEndpointIpAddress',
            'private_endpoint_dns_alias': 'privateEndpointDnsAlias',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'azure_identity_mechanism': 'azureIdentityMechanism',
            'azure_identity_connectivity_status': 'azureIdentityConnectivityStatus',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'last_modification': 'lastModification',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._db_cluster_resource_id = None
        self._display_name = None
        self._arc_agent_nodes = None
        self._azure_tenant_id = None
        self._azure_subscription_id = None
        self._azure_resource_group = None
        self._private_endpoint_ip_address = None
        self._private_endpoint_dns_alias = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._azure_identity_mechanism = None
        self._azure_identity_connectivity_status = None
        self._time_created = None
        self._time_updated = None
        self._last_modification = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        Gets the id of this OracleDbAzureConnectorSummary.
        The `OCID`__ of the Oracle DB Azure Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OracleDbAzureConnectorSummary.
        The `OCID`__ of the Oracle DB Azure Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this OracleDbAzureConnectorSummary.
        The `OCID`__ of the compartment that contains Oracle DB Azure Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OracleDbAzureConnectorSummary.
        The `OCID`__ of the compartment that contains Oracle DB Azure Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def db_cluster_resource_id(self):
        """
        Gets the db_cluster_resource_id of this OracleDbAzureConnectorSummary.
        The `OCID`__ of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The db_cluster_resource_id of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._db_cluster_resource_id

    @db_cluster_resource_id.setter
    def db_cluster_resource_id(self, db_cluster_resource_id):
        """
        Sets the db_cluster_resource_id of this OracleDbAzureConnectorSummary.
        The `OCID`__ of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param db_cluster_resource_id: The db_cluster_resource_id of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._db_cluster_resource_id = db_cluster_resource_id

    @property
    def display_name(self):
        """
        Gets the display_name of this OracleDbAzureConnectorSummary.
        Oracle DB Azure Connector resource name.


        :return: The display_name of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OracleDbAzureConnectorSummary.
        Oracle DB Azure Connector resource name.


        :param display_name: The display_name of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def arc_agent_nodes(self):
        """
        Gets the arc_agent_nodes of this OracleDbAzureConnectorSummary.
        List of all VMs where Arc Agent Identity is configure under Oracle Cloud VM Cluster.


        :return: The arc_agent_nodes of this OracleDbAzureConnectorSummary.
        :rtype: list[oci.dbmulticloud.models.ArcAgentNodes]
        """
        return self._arc_agent_nodes

    @arc_agent_nodes.setter
    def arc_agent_nodes(self, arc_agent_nodes):
        """
        Sets the arc_agent_nodes of this OracleDbAzureConnectorSummary.
        List of all VMs where Arc Agent Identity is configure under Oracle Cloud VM Cluster.


        :param arc_agent_nodes: The arc_agent_nodes of this OracleDbAzureConnectorSummary.
        :type: list[oci.dbmulticloud.models.ArcAgentNodes]
        """
        self._arc_agent_nodes = arc_agent_nodes

    @property
    def azure_tenant_id(self):
        """
        Gets the azure_tenant_id of this OracleDbAzureConnectorSummary.
        Azure Tenant ID.


        :return: The azure_tenant_id of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._azure_tenant_id

    @azure_tenant_id.setter
    def azure_tenant_id(self, azure_tenant_id):
        """
        Sets the azure_tenant_id of this OracleDbAzureConnectorSummary.
        Azure Tenant ID.


        :param azure_tenant_id: The azure_tenant_id of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._azure_tenant_id = azure_tenant_id

    @property
    def azure_subscription_id(self):
        """
        Gets the azure_subscription_id of this OracleDbAzureConnectorSummary.
        Azure Subscription ID.


        :return: The azure_subscription_id of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._azure_subscription_id

    @azure_subscription_id.setter
    def azure_subscription_id(self, azure_subscription_id):
        """
        Sets the azure_subscription_id of this OracleDbAzureConnectorSummary.
        Azure Subscription ID.


        :param azure_subscription_id: The azure_subscription_id of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._azure_subscription_id = azure_subscription_id

    @property
    def azure_resource_group(self):
        """
        Gets the azure_resource_group of this OracleDbAzureConnectorSummary.
        Azure Resource group name.


        :return: The azure_resource_group of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._azure_resource_group

    @azure_resource_group.setter
    def azure_resource_group(self, azure_resource_group):
        """
        Sets the azure_resource_group of this OracleDbAzureConnectorSummary.
        Azure Resource group name.


        :param azure_resource_group: The azure_resource_group of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._azure_resource_group = azure_resource_group

    @property
    def private_endpoint_ip_address(self):
        """
        Gets the private_endpoint_ip_address of this OracleDbAzureConnectorSummary.
        Private endpoint IP.


        :return: The private_endpoint_ip_address of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._private_endpoint_ip_address

    @private_endpoint_ip_address.setter
    def private_endpoint_ip_address(self, private_endpoint_ip_address):
        """
        Sets the private_endpoint_ip_address of this OracleDbAzureConnectorSummary.
        Private endpoint IP.


        :param private_endpoint_ip_address: The private_endpoint_ip_address of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._private_endpoint_ip_address = private_endpoint_ip_address

    @property
    def private_endpoint_dns_alias(self):
        """
        Gets the private_endpoint_dns_alias of this OracleDbAzureConnectorSummary.
        Private endpoint's DNS alias.


        :return: The private_endpoint_dns_alias of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._private_endpoint_dns_alias

    @private_endpoint_dns_alias.setter
    def private_endpoint_dns_alias(self, private_endpoint_dns_alias):
        """
        Sets the private_endpoint_dns_alias of this OracleDbAzureConnectorSummary.
        Private endpoint's DNS alias.


        :param private_endpoint_dns_alias: The private_endpoint_dns_alias of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._private_endpoint_dns_alias = private_endpoint_dns_alias

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OracleDbAzureConnectorSummary.
        The current lifecycle state of the Oracle DB Azure Connector resource.


        :return: The lifecycle_state of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OracleDbAzureConnectorSummary.
        The current lifecycle state of the Oracle DB Azure Connector resource.


        :param lifecycle_state: The lifecycle_state of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this OracleDbAzureConnectorSummary.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this OracleDbAzureConnectorSummary.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def azure_identity_mechanism(self):
        """
        Gets the azure_identity_mechanism of this OracleDbAzureConnectorSummary.
        Azure Identity mechanism.


        :return: The azure_identity_mechanism of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._azure_identity_mechanism

    @azure_identity_mechanism.setter
    def azure_identity_mechanism(self, azure_identity_mechanism):
        """
        Sets the azure_identity_mechanism of this OracleDbAzureConnectorSummary.
        Azure Identity mechanism.


        :param azure_identity_mechanism: The azure_identity_mechanism of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._azure_identity_mechanism = azure_identity_mechanism

    @property
    def azure_identity_connectivity_status(self):
        """
        Gets the azure_identity_connectivity_status of this OracleDbAzureConnectorSummary.
        The current lifecycle state of the Oracle DB Azure Identity Connector resource.


        :return: The azure_identity_connectivity_status of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._azure_identity_connectivity_status

    @azure_identity_connectivity_status.setter
    def azure_identity_connectivity_status(self, azure_identity_connectivity_status):
        """
        Sets the azure_identity_connectivity_status of this OracleDbAzureConnectorSummary.
        The current lifecycle state of the Oracle DB Azure Identity Connector resource.


        :param azure_identity_connectivity_status: The azure_identity_connectivity_status of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._azure_identity_connectivity_status = azure_identity_connectivity_status

    @property
    def time_created(self):
        """
        Gets the time_created of this OracleDbAzureConnectorSummary.
        Time when the Oracle DB Azure Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this OracleDbAzureConnectorSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OracleDbAzureConnectorSummary.
        Time when the Oracle DB Azure Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this OracleDbAzureConnectorSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OracleDbAzureConnectorSummary.
        Time when the Oracle DB Azure Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this OracleDbAzureConnectorSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OracleDbAzureConnectorSummary.
        Time when the Oracle DB Azure Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this OracleDbAzureConnectorSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def last_modification(self):
        """
        Gets the last_modification of this OracleDbAzureConnectorSummary.
        Description of the latest modification of the Oracle DB Azure Connector resource.


        :return: The last_modification of this OracleDbAzureConnectorSummary.
        :rtype: str
        """
        return self._last_modification

    @last_modification.setter
    def last_modification(self, last_modification):
        """
        Sets the last_modification of this OracleDbAzureConnectorSummary.
        Description of the latest modification of the Oracle DB Azure Connector resource.


        :param last_modification: The last_modification of this OracleDbAzureConnectorSummary.
        :type: str
        """
        self._last_modification = last_modification

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OracleDbAzureConnectorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this OracleDbAzureConnectorSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OracleDbAzureConnectorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this OracleDbAzureConnectorSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OracleDbAzureConnectorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this OracleDbAzureConnectorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OracleDbAzureConnectorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this OracleDbAzureConnectorSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OracleDbAzureConnectorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OracleDbAzureConnectorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OracleDbAzureConnectorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OracleDbAzureConnectorSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
