# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleDbAwsIdentityConnector(object):
    """
    Oracle DB AWS Connector resource object.
    """

    #: A constant which can be used with the lifecycle_state property of a OracleDbAwsIdentityConnector.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAwsIdentityConnector.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAwsIdentityConnector.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAwsIdentityConnector.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAwsIdentityConnector.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAwsIdentityConnector.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new OracleDbAwsIdentityConnector object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleDbAwsIdentityConnector.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this OracleDbAwsIdentityConnector.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleDbAwsIdentityConnector.
        :type compartment_id: str

        :param resource_id:
            The value to assign to the resource_id property of this OracleDbAwsIdentityConnector.
        :type resource_id: str

        :param issuer_url:
            The value to assign to the issuer_url property of this OracleDbAwsIdentityConnector.
        :type issuer_url: str

        :param oidc_scope:
            The value to assign to the oidc_scope property of this OracleDbAwsIdentityConnector.
        :type oidc_scope: str

        :param service_role_details:
            The value to assign to the service_role_details property of this OracleDbAwsIdentityConnector.
        :type service_role_details: list[oci.dbmulticloud.models.ServiceRoleDetails]

        :param aws_location:
            The value to assign to the aws_location property of this OracleDbAwsIdentityConnector.
        :type aws_location: str

        :param aws_sts_private_endpoint:
            The value to assign to the aws_sts_private_endpoint property of this OracleDbAwsIdentityConnector.
        :type aws_sts_private_endpoint: str

        :param aws_account_id:
            The value to assign to the aws_account_id property of this OracleDbAwsIdentityConnector.
        :type aws_account_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleDbAwsIdentityConnector.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this OracleDbAwsIdentityConnector.
        :type lifecycle_state_details: str

        :param time_created:
            The value to assign to the time_created property of this OracleDbAwsIdentityConnector.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleDbAwsIdentityConnector.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleDbAwsIdentityConnector.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleDbAwsIdentityConnector.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleDbAwsIdentityConnector.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'resource_id': 'str',
            'issuer_url': 'str',
            'oidc_scope': 'str',
            'service_role_details': 'list[ServiceRoleDetails]',
            'aws_location': 'str',
            'aws_sts_private_endpoint': 'str',
            'aws_account_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'resource_id': 'resourceId',
            'issuer_url': 'issuerUrl',
            'oidc_scope': 'oidcScope',
            'service_role_details': 'serviceRoleDetails',
            'aws_location': 'awsLocation',
            'aws_sts_private_endpoint': 'awsStsPrivateEndpoint',
            'aws_account_id': 'awsAccountId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._resource_id = None
        self._issuer_url = None
        self._oidc_scope = None
        self._service_role_details = None
        self._aws_location = None
        self._aws_sts_private_endpoint = None
        self._aws_account_id = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OracleDbAwsIdentityConnector.
        The `OCID`__ of the Oracle DB AWS Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OracleDbAwsIdentityConnector.
        The `OCID`__ of the Oracle DB AWS Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this OracleDbAwsIdentityConnector.
        Oracle DB AWS Identity Connector resource name.


        :return: The display_name of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OracleDbAwsIdentityConnector.
        Oracle DB AWS Identity Connector resource name.


        :param display_name: The display_name of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OracleDbAwsIdentityConnector.
        The `OCID`__ of the compartment that contains Oracle DB AWS Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OracleDbAwsIdentityConnector.
        The `OCID`__ of the compartment that contains Oracle DB AWS Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this OracleDbAwsIdentityConnector.
        The `OCID`__ of the AWS VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this OracleDbAwsIdentityConnector.
        The `OCID`__ of the AWS VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def issuer_url(self):
        """
        **[Required]** Gets the issuer_url of this OracleDbAwsIdentityConnector.
        OIDC token issuer Url.


        :return: The issuer_url of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._issuer_url

    @issuer_url.setter
    def issuer_url(self, issuer_url):
        """
        Sets the issuer_url of this OracleDbAwsIdentityConnector.
        OIDC token issuer Url.


        :param issuer_url: The issuer_url of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._issuer_url = issuer_url

    @property
    def oidc_scope(self):
        """
        Gets the oidc_scope of this OracleDbAwsIdentityConnector.
        OCI IAM Domain scope for issuer URL.


        :return: The oidc_scope of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._oidc_scope

    @oidc_scope.setter
    def oidc_scope(self, oidc_scope):
        """
        Sets the oidc_scope of this OracleDbAwsIdentityConnector.
        OCI IAM Domain scope for issuer URL.


        :param oidc_scope: The oidc_scope of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._oidc_scope = oidc_scope

    @property
    def service_role_details(self):
        """
        **[Required]** Gets the service_role_details of this OracleDbAwsIdentityConnector.
        Service role details and respective Amazon resource nam of Role.


        :return: The service_role_details of this OracleDbAwsIdentityConnector.
        :rtype: list[oci.dbmulticloud.models.ServiceRoleDetails]
        """
        return self._service_role_details

    @service_role_details.setter
    def service_role_details(self, service_role_details):
        """
        Sets the service_role_details of this OracleDbAwsIdentityConnector.
        Service role details and respective Amazon resource nam of Role.


        :param service_role_details: The service_role_details of this OracleDbAwsIdentityConnector.
        :type: list[oci.dbmulticloud.models.ServiceRoleDetails]
        """
        self._service_role_details = service_role_details

    @property
    def aws_location(self):
        """
        **[Required]** Gets the aws_location of this OracleDbAwsIdentityConnector.
        AWS resource location.


        :return: The aws_location of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._aws_location

    @aws_location.setter
    def aws_location(self, aws_location):
        """
        Sets the aws_location of this OracleDbAwsIdentityConnector.
        AWS resource location.


        :param aws_location: The aws_location of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._aws_location = aws_location

    @property
    def aws_sts_private_endpoint(self):
        """
        Gets the aws_sts_private_endpoint of this OracleDbAwsIdentityConnector.
        Private endpoint of AWS Security Token Service.


        :return: The aws_sts_private_endpoint of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._aws_sts_private_endpoint

    @aws_sts_private_endpoint.setter
    def aws_sts_private_endpoint(self, aws_sts_private_endpoint):
        """
        Sets the aws_sts_private_endpoint of this OracleDbAwsIdentityConnector.
        Private endpoint of AWS Security Token Service.


        :param aws_sts_private_endpoint: The aws_sts_private_endpoint of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._aws_sts_private_endpoint = aws_sts_private_endpoint

    @property
    def aws_account_id(self):
        """
        Gets the aws_account_id of this OracleDbAwsIdentityConnector.
        AWS Account ID.


        :return: The aws_account_id of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._aws_account_id

    @aws_account_id.setter
    def aws_account_id(self, aws_account_id):
        """
        Sets the aws_account_id of this OracleDbAwsIdentityConnector.
        AWS Account ID.


        :param aws_account_id: The aws_account_id of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._aws_account_id = aws_account_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OracleDbAwsIdentityConnector.
        The current lifecycle state of the AWS Identity Connector resource.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OracleDbAwsIdentityConnector.
        The current lifecycle state of the AWS Identity Connector resource.


        :param lifecycle_state: The lifecycle_state of this OracleDbAwsIdentityConnector.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this OracleDbAwsIdentityConnector.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this OracleDbAwsIdentityConnector.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this OracleDbAwsIdentityConnector.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this OracleDbAwsIdentityConnector.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def time_created(self):
        """
        Gets the time_created of this OracleDbAwsIdentityConnector.
        Time when the Oracle DB AWS Identity Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this OracleDbAwsIdentityConnector.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OracleDbAwsIdentityConnector.
        Time when the Oracle DB AWS Identity Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this OracleDbAwsIdentityConnector.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OracleDbAwsIdentityConnector.
        Time when the Oracle DB AWS Identity Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this OracleDbAwsIdentityConnector.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OracleDbAwsIdentityConnector.
        Time when the Oracle DB AWS Identity Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this OracleDbAwsIdentityConnector.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OracleDbAwsIdentityConnector.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this OracleDbAwsIdentityConnector.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OracleDbAwsIdentityConnector.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this OracleDbAwsIdentityConnector.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OracleDbAwsIdentityConnector.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this OracleDbAwsIdentityConnector.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OracleDbAwsIdentityConnector.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this OracleDbAwsIdentityConnector.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OracleDbAwsIdentityConnector.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OracleDbAwsIdentityConnector.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OracleDbAwsIdentityConnector.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OracleDbAwsIdentityConnector.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
