# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricError(object):
    """
    Metric error content.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricError object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_generated:
            The value to assign to the time_generated property of this MetricError.
        :type time_generated: datetime

        :param error_type:
            The value to assign to the error_type property of this MetricError.
        :type error_type: str

        :param content_type:
            The value to assign to the content_type property of this MetricError.
        :type content_type: str

        :param data:
            The value to assign to the data property of this MetricError.
        :type data: str

        :param subject:
            The value to assign to the subject property of this MetricError.
        :type subject: str

        :param level:
            The value to assign to the level property of this MetricError.
        :type level: str

        """
        self.swagger_types = {
            'time_generated': 'datetime',
            'error_type': 'str',
            'content_type': 'str',
            'data': 'str',
            'subject': 'str',
            'level': 'str'
        }
        self.attribute_map = {
            'time_generated': 'timeGenerated',
            'error_type': 'errorType',
            'content_type': 'contentType',
            'data': 'data',
            'subject': 'subject',
            'level': 'level'
        }
        self._time_generated = None
        self._error_type = None
        self._content_type = None
        self._data = None
        self._subject = None
        self._level = None

    @property
    def time_generated(self):
        """
        **[Required]** Gets the time_generated of this MetricError.
        Time the error record was generated


        :return: The time_generated of this MetricError.
        :rtype: datetime
        """
        return self._time_generated

    @time_generated.setter
    def time_generated(self, time_generated):
        """
        Sets the time_generated of this MetricError.
        Time the error record was generated


        :param time_generated: The time_generated of this MetricError.
        :type: datetime
        """
        self._time_generated = time_generated

    @property
    def error_type(self):
        """
        **[Required]** Gets the error_type of this MetricError.
        Error type


        :return: The error_type of this MetricError.
        :rtype: str
        """
        return self._error_type

    @error_type.setter
    def error_type(self, error_type):
        """
        Sets the error_type of this MetricError.
        Error type


        :param error_type: The error_type of this MetricError.
        :type: str
        """
        self._error_type = error_type

    @property
    def content_type(self):
        """
        **[Required]** Gets the content_type of this MetricError.
        Content type


        :return: The content_type of this MetricError.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this MetricError.
        Content type


        :param content_type: The content_type of this MetricError.
        :type: str
        """
        self._content_type = content_type

    @property
    def data(self):
        """
        **[Required]** Gets the data of this MetricError.
        Data


        :return: The data of this MetricError.
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this MetricError.
        Data


        :param data: The data of this MetricError.
        :type: str
        """
        self._data = data

    @property
    def subject(self):
        """
        **[Required]** Gets the subject of this MetricError.
        Subject


        :return: The subject of this MetricError.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Sets the subject of this MetricError.
        Subject


        :param subject: The subject of this MetricError.
        :type: str
        """
        self._subject = subject

    @property
    def level(self):
        """
        **[Required]** Gets the level of this MetricError.
        Level


        :return: The level of this MetricError.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this MetricError.
        Level


        :param level: The level of this MetricError.
        :type: str
        """
        self._level = level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
