# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .clone_assessment_details import CloneAssessmentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleCloneAssessmentDetails(CloneAssessmentDetails):
    """
    Oracle Clone Assessment Summary
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OracleCloneAssessmentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.OracleCloneAssessmentDetails.database_combination` attribute
        of this class is ``ORACLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_combination:
            The value to assign to the database_combination property of this OracleCloneAssessmentDetails.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this OracleCloneAssessmentDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleCloneAssessmentDetails.
        :type compartment_id: str

        :param source_database_connection:
            The value to assign to the source_database_connection property of this OracleCloneAssessmentDetails.
        :type source_database_connection: oci.database_migration.models.SourceAssessmentConnection

        :param target_database_connection:
            The value to assign to the target_database_connection property of this OracleCloneAssessmentDetails.
        :type target_database_connection: oci.database_migration.models.TargetAssessmentConnection

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleCloneAssessmentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleCloneAssessmentDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'database_combination': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'source_database_connection': 'SourceAssessmentConnection',
            'target_database_connection': 'TargetAssessmentConnection',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'source_database_connection': 'sourceDatabaseConnection',
            'target_database_connection': 'targetDatabaseConnection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._database_combination = None
        self._display_name = None
        self._compartment_id = None
        self._source_database_connection = None
        self._target_database_connection = None
        self._freeform_tags = None
        self._defined_tags = None
        self._database_combination = 'ORACLE'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
