# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .assessment_object_collection import AssessmentObjectCollection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlAssessmentObjectCollection(AssessmentObjectCollection):
    """
    List of affected database objects.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlAssessmentObjectCollection object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.MySqlAssessmentObjectCollection.database_combination` attribute
        of this class is ``MYSQL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_combination:
            The value to assign to the database_combination property of this MySqlAssessmentObjectCollection.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param items:
            The value to assign to the items property of this MySqlAssessmentObjectCollection.
        :type items: list[oci.database_migration.models.MySqlDatabaseObjectSummary]

        """
        self.swagger_types = {
            'database_combination': 'str',
            'items': 'list[MySqlDatabaseObjectSummary]'
        }
        self.attribute_map = {
            'database_combination': 'databaseCombination',
            'items': 'items'
        }
        self._database_combination = None
        self._items = None
        self._database_combination = 'MYSQL'

    @property
    def items(self):
        """
        **[Required]** Gets the items of this MySqlAssessmentObjectCollection.
        An array of affected database objects.


        :return: The items of this MySqlAssessmentObjectCollection.
        :rtype: list[oci.database_migration.models.MySqlDatabaseObjectSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this MySqlAssessmentObjectCollection.
        An array of affected database objects.


        :param items: The items of this MySqlAssessmentObjectCollection.
        :type: list[oci.database_migration.models.MySqlDatabaseObjectSummary]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
