# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloneAssessmentDetails(object):
    """
    Customizable details when performing cloning of an Assessment.
    """

    #: A constant which can be used with the database_combination property of a CloneAssessmentDetails.
    #: This constant has a value of "MYSQL"
    DATABASE_COMBINATION_MYSQL = "MYSQL"

    #: A constant which can be used with the database_combination property of a CloneAssessmentDetails.
    #: This constant has a value of "ORACLE"
    DATABASE_COMBINATION_ORACLE = "ORACLE"

    def __init__(self, **kwargs):
        """
        Initializes a new CloneAssessmentDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_migration.models.MySqlCloneAssessmentDetails`
        * :class:`~oci.database_migration.models.OracleCloneAssessmentDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_combination:
            The value to assign to the database_combination property of this CloneAssessmentDetails.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this CloneAssessmentDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CloneAssessmentDetails.
        :type compartment_id: str

        :param source_database_connection:
            The value to assign to the source_database_connection property of this CloneAssessmentDetails.
        :type source_database_connection: oci.database_migration.models.SourceAssessmentConnection

        :param target_database_connection:
            The value to assign to the target_database_connection property of this CloneAssessmentDetails.
        :type target_database_connection: oci.database_migration.models.TargetAssessmentConnection

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CloneAssessmentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CloneAssessmentDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'database_combination': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'source_database_connection': 'SourceAssessmentConnection',
            'target_database_connection': 'TargetAssessmentConnection',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'source_database_connection': 'sourceDatabaseConnection',
            'target_database_connection': 'targetDatabaseConnection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._database_combination = None
        self._display_name = None
        self._compartment_id = None
        self._source_database_connection = None
        self._target_database_connection = None
        self._freeform_tags = None
        self._defined_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['databaseCombination']

        if type == 'MYSQL':
            return 'MySqlCloneAssessmentDetails'

        if type == 'ORACLE':
            return 'OracleCloneAssessmentDetails'
        else:
            return 'CloneAssessmentDetails'

    @property
    def database_combination(self):
        """
        **[Required]** Gets the database_combination of this CloneAssessmentDetails.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.

        Allowed values for this property are: "MYSQL", "ORACLE"


        :return: The database_combination of this CloneAssessmentDetails.
        :rtype: str
        """
        return self._database_combination

    @database_combination.setter
    def database_combination(self, database_combination):
        """
        Sets the database_combination of this CloneAssessmentDetails.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.


        :param database_combination: The database_combination of this CloneAssessmentDetails.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(database_combination, allowed_values):
            raise ValueError(
                f"Invalid value for `database_combination`, must be None or one of {allowed_values}"
            )
        self._database_combination = database_combination

    @property
    def display_name(self):
        """
        Gets the display_name of this CloneAssessmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CloneAssessmentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CloneAssessmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CloneAssessmentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CloneAssessmentDetails.
        The OCID of the resource being referenced.


        :return: The compartment_id of this CloneAssessmentDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CloneAssessmentDetails.
        The OCID of the resource being referenced.


        :param compartment_id: The compartment_id of this CloneAssessmentDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def source_database_connection(self):
        """
        **[Required]** Gets the source_database_connection of this CloneAssessmentDetails.

        :return: The source_database_connection of this CloneAssessmentDetails.
        :rtype: oci.database_migration.models.SourceAssessmentConnection
        """
        return self._source_database_connection

    @source_database_connection.setter
    def source_database_connection(self, source_database_connection):
        """
        Sets the source_database_connection of this CloneAssessmentDetails.

        :param source_database_connection: The source_database_connection of this CloneAssessmentDetails.
        :type: oci.database_migration.models.SourceAssessmentConnection
        """
        self._source_database_connection = source_database_connection

    @property
    def target_database_connection(self):
        """
        **[Required]** Gets the target_database_connection of this CloneAssessmentDetails.

        :return: The target_database_connection of this CloneAssessmentDetails.
        :rtype: oci.database_migration.models.TargetAssessmentConnection
        """
        return self._target_database_connection

    @target_database_connection.setter
    def target_database_connection(self, target_database_connection):
        """
        Sets the target_database_connection of this CloneAssessmentDetails.

        :param target_database_connection: The target_database_connection of this CloneAssessmentDetails.
        :type: oci.database_migration.models.TargetAssessmentConnection
        """
        self._target_database_connection = target_database_connection

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CloneAssessmentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :return: The freeform_tags of this CloneAssessmentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CloneAssessmentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :param freeform_tags: The freeform_tags of this CloneAssessmentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CloneAssessmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CloneAssessmentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CloneAssessmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CloneAssessmentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
