# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssessorSummary(object):
    """
    Assessor Summary
    """

    #: A constant which can be used with the lifecycle_state property of a AssessorSummary.
    #: This constant has a value of "ACCEPTED"
    LIFECYCLE_STATE_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the lifecycle_state property of a AssessorSummary.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a AssessorSummary.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a AssessorSummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a AssessorSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new AssessorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param assessment_id:
            The value to assign to the assessment_id property of this AssessorSummary.
        :type assessment_id: str

        :param name:
            The value to assign to the name property of this AssessorSummary.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this AssessorSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AssessorSummary.
        :type description: str

        :param help_link_url:
            The value to assign to the help_link_url property of this AssessorSummary.
        :type help_link_url: str

        :param help_link_text:
            The value to assign to the help_link_text property of this AssessorSummary.
        :type help_link_text: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AssessorSummary.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "SUCCEEDED", "NEEDS_ATTENTION", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param assessor_group:
            The value to assign to the assessor_group property of this AssessorSummary.
        :type assessor_group: oci.database_migration.models.AssessorGroup

        :param actions:
            The value to assign to the actions property of this AssessorSummary.
        :type actions: list[oci.database_migration.models.AssessorAction]

        :param assessor_result:
            The value to assign to the assessor_result property of this AssessorSummary.
        :type assessor_result: str

        :param checks_summary:
            The value to assign to the checks_summary property of this AssessorSummary.
        :type checks_summary: str

        :param has_script:
            The value to assign to the has_script property of this AssessorSummary.
        :type has_script: bool

        :param script:
            The value to assign to the script property of this AssessorSummary.
        :type script: str

        :param does_script_require_restart:
            The value to assign to the does_script_require_restart property of this AssessorSummary.
        :type does_script_require_restart: bool

        """
        self.swagger_types = {
            'assessment_id': 'str',
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'help_link_url': 'str',
            'help_link_text': 'str',
            'lifecycle_state': 'str',
            'assessor_group': 'AssessorGroup',
            'actions': 'list[AssessorAction]',
            'assessor_result': 'str',
            'checks_summary': 'str',
            'has_script': 'bool',
            'script': 'str',
            'does_script_require_restart': 'bool'
        }
        self.attribute_map = {
            'assessment_id': 'assessmentId',
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'help_link_url': 'helpLinkUrl',
            'help_link_text': 'helpLinkText',
            'lifecycle_state': 'lifecycleState',
            'assessor_group': 'assessorGroup',
            'actions': 'actions',
            'assessor_result': 'assessorResult',
            'checks_summary': 'checksSummary',
            'has_script': 'hasScript',
            'script': 'script',
            'does_script_require_restart': 'doesScriptRequireRestart'
        }
        self._assessment_id = None
        self._name = None
        self._display_name = None
        self._description = None
        self._help_link_url = None
        self._help_link_text = None
        self._lifecycle_state = None
        self._assessor_group = None
        self._actions = None
        self._assessor_result = None
        self._checks_summary = None
        self._has_script = None
        self._script = None
        self._does_script_require_restart = None

    @property
    def assessment_id(self):
        """
        **[Required]** Gets the assessment_id of this AssessorSummary.
        The OCID of the resource being referenced.


        :return: The assessment_id of this AssessorSummary.
        :rtype: str
        """
        return self._assessment_id

    @assessment_id.setter
    def assessment_id(self, assessment_id):
        """
        Sets the assessment_id of this AssessorSummary.
        The OCID of the resource being referenced.


        :param assessment_id: The assessment_id of this AssessorSummary.
        :type: str
        """
        self._assessment_id = assessment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AssessorSummary.
        The Assessor Name.


        :return: The name of this AssessorSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssessorSummary.
        The Assessor Name.


        :param name: The name of this AssessorSummary.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AssessorSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this AssessorSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssessorSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this AssessorSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this AssessorSummary.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this AssessorSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AssessorSummary.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this AssessorSummary.
        :type: str
        """
        self._description = description

    @property
    def help_link_url(self):
        """
        **[Required]** Gets the help_link_url of this AssessorSummary.
        The Help URL.


        :return: The help_link_url of this AssessorSummary.
        :rtype: str
        """
        return self._help_link_url

    @help_link_url.setter
    def help_link_url(self, help_link_url):
        """
        Sets the help_link_url of this AssessorSummary.
        The Help URL.


        :param help_link_url: The help_link_url of this AssessorSummary.
        :type: str
        """
        self._help_link_url = help_link_url

    @property
    def help_link_text(self):
        """
        **[Required]** Gets the help_link_text of this AssessorSummary.
        The Help link text.


        :return: The help_link_text of this AssessorSummary.
        :rtype: str
        """
        return self._help_link_text

    @help_link_text.setter
    def help_link_text(self, help_link_text):
        """
        Sets the help_link_text of this AssessorSummary.
        The Help link text.


        :param help_link_text: The help_link_text of this AssessorSummary.
        :type: str
        """
        self._help_link_text = help_link_text

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AssessorSummary.
        The current state of the Assessor.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "SUCCEEDED", "NEEDS_ATTENTION", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this AssessorSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AssessorSummary.
        The current state of the Assessor.


        :param lifecycle_state: The lifecycle_state of this AssessorSummary.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "SUCCEEDED", "NEEDS_ATTENTION", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def assessor_group(self):
        """
        Gets the assessor_group of this AssessorSummary.

        :return: The assessor_group of this AssessorSummary.
        :rtype: oci.database_migration.models.AssessorGroup
        """
        return self._assessor_group

    @assessor_group.setter
    def assessor_group(self, assessor_group):
        """
        Sets the assessor_group of this AssessorSummary.

        :param assessor_group: The assessor_group of this AssessorSummary.
        :type: oci.database_migration.models.AssessorGroup
        """
        self._assessor_group = assessor_group

    @property
    def actions(self):
        """
        **[Required]** Gets the actions of this AssessorSummary.
        Assessor actions.


        :return: The actions of this AssessorSummary.
        :rtype: list[oci.database_migration.models.AssessorAction]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """
        Sets the actions of this AssessorSummary.
        Assessor actions.


        :param actions: The actions of this AssessorSummary.
        :type: list[oci.database_migration.models.AssessorAction]
        """
        self._actions = actions

    @property
    def assessor_result(self):
        """
        Gets the assessor_result of this AssessorSummary.
        The Assessor Result text.


        :return: The assessor_result of this AssessorSummary.
        :rtype: str
        """
        return self._assessor_result

    @assessor_result.setter
    def assessor_result(self, assessor_result):
        """
        Sets the assessor_result of this AssessorSummary.
        The Assessor Result text.


        :param assessor_result: The assessor_result of this AssessorSummary.
        :type: str
        """
        self._assessor_result = assessor_result

    @property
    def checks_summary(self):
        """
        Gets the checks_summary of this AssessorSummary.
        The Summary of all Checks.


        :return: The checks_summary of this AssessorSummary.
        :rtype: str
        """
        return self._checks_summary

    @checks_summary.setter
    def checks_summary(self, checks_summary):
        """
        Sets the checks_summary of this AssessorSummary.
        The Summary of all Checks.


        :param checks_summary: The checks_summary of this AssessorSummary.
        :type: str
        """
        self._checks_summary = checks_summary

    @property
    def has_script(self):
        """
        Gets the has_script of this AssessorSummary.
        True if script is available either from 'script' property of through download, false otherwise.


        :return: The has_script of this AssessorSummary.
        :rtype: bool
        """
        return self._has_script

    @has_script.setter
    def has_script(self, has_script):
        """
        Sets the has_script of this AssessorSummary.
        True if script is available either from 'script' property of through download, false otherwise.


        :param has_script: The has_script of this AssessorSummary.
        :type: bool
        """
        self._has_script = has_script

    @property
    def script(self):
        """
        Gets the script of this AssessorSummary.
        The generated SQL script. Can be empty if the script exceeds maxLength.
        In this case the property 'hasScript' indicates that the script is available for download.


        :return: The script of this AssessorSummary.
        :rtype: str
        """
        return self._script

    @script.setter
    def script(self, script):
        """
        Sets the script of this AssessorSummary.
        The generated SQL script. Can be empty if the script exceeds maxLength.
        In this case the property 'hasScript' indicates that the script is available for download.


        :param script: The script of this AssessorSummary.
        :type: str
        """
        self._script = script

    @property
    def does_script_require_restart(self):
        """
        Gets the does_script_require_restart of this AssessorSummary.
        True if DB restart required after running the script, false otherwise.


        :return: The does_script_require_restart of this AssessorSummary.
        :rtype: bool
        """
        return self._does_script_require_restart

    @does_script_require_restart.setter
    def does_script_require_restart(self, does_script_require_restart):
        """
        Sets the does_script_require_restart of this AssessorSummary.
        True if DB restart required after running the script, false otherwise.


        :param does_script_require_restart: The does_script_require_restart of this AssessorSummary.
        :type: bool
        """
        self._does_script_require_restart = does_script_require_restart

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
