# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .update_advisor_report_check_objects_details import UpdateAdvisorReportCheckObjectsDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AllUpdateAdvisorReportCheckObjectsDetails(UpdateAdvisorReportCheckObjectsDetails):
    """
    Exclude all check objects.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AllUpdateAdvisorReportCheckObjectsDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.AllUpdateAdvisorReportCheckObjectsDetails.kind` attribute
        of this class is ``ALL_OBJECTS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this AllUpdateAdvisorReportCheckObjectsDetails.
            Allowed values for this property are: "ALL_OBJECTS", "LIST_OBJECTS"
        :type kind: str

        :param is_exclude:
            The value to assign to the is_exclude property of this AllUpdateAdvisorReportCheckObjectsDetails.
        :type is_exclude: bool

        """
        self.swagger_types = {
            'kind': 'str',
            'is_exclude': 'bool'
        }
        self.attribute_map = {
            'kind': 'kind',
            'is_exclude': 'isExclude'
        }
        self._kind = None
        self._is_exclude = None
        self._kind = 'ALL_OBJECTS'

    @property
    def is_exclude(self):
        """
        Gets the is_exclude of this AllUpdateAdvisorReportCheckObjectsDetails.
        Flag showing the action on the object.


        :return: The is_exclude of this AllUpdateAdvisorReportCheckObjectsDetails.
        :rtype: bool
        """
        return self._is_exclude

    @is_exclude.setter
    def is_exclude(self, is_exclude):
        """
        Sets the is_exclude of this AllUpdateAdvisorReportCheckObjectsDetails.
        Flag showing the action on the object.


        :param is_exclude: The is_exclude of this AllUpdateAdvisorReportCheckObjectsDetails.
        :type: bool
        """
        self._is_exclude = is_exclude

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
