# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlChannelFetchError(object):
    """
    MySQL server replication channel name and error from its fetch operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlChannelFetchError object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param channel_name:
            The value to assign to the channel_name property of this MySqlChannelFetchError.
        :type channel_name: str

        :param fetch_error:
            The value to assign to the fetch_error property of this MySqlChannelFetchError.
        :type fetch_error: oci.database_management.models.MySqlFetchError

        """
        self.swagger_types = {
            'channel_name': 'str',
            'fetch_error': 'MySqlFetchError'
        }
        self.attribute_map = {
            'channel_name': 'channelName',
            'fetch_error': 'fetchError'
        }
        self._channel_name = None
        self._fetch_error = None

    @property
    def channel_name(self):
        """
        Gets the channel_name of this MySqlChannelFetchError.
        The name of the replication channel.


        :return: The channel_name of this MySqlChannelFetchError.
        :rtype: str
        """
        return self._channel_name

    @channel_name.setter
    def channel_name(self, channel_name):
        """
        Sets the channel_name of this MySqlChannelFetchError.
        The name of the replication channel.


        :param channel_name: The channel_name of this MySqlChannelFetchError.
        :type: str
        """
        self._channel_name = channel_name

    @property
    def fetch_error(self):
        """
        **[Required]** Gets the fetch_error of this MySqlChannelFetchError.

        :return: The fetch_error of this MySqlChannelFetchError.
        :rtype: oci.database_management.models.MySqlFetchError
        """
        return self._fetch_error

    @fetch_error.setter
    def fetch_error(self, fetch_error):
        """
        Sets the fetch_error of this MySqlChannelFetchError.

        :param fetch_error: The fetch_error of this MySqlChannelFetchError.
        :type: oci.database_management.models.MySqlFetchError
        """
        self._fetch_error = fetch_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
