# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadataInfrastructureUsageMetrics(object):
    """
    The list of aggregated metrics for Exadata infrastructures in the fleet.
    """

    #: A constant which can be used with the deployment_type property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "ONPREMISE"
    DEPLOYMENT_TYPE_ONPREMISE = "ONPREMISE"

    #: A constant which can be used with the deployment_type property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "EXADATA"
    DEPLOYMENT_TYPE_EXADATA = "EXADATA"

    #: A constant which can be used with the deployment_type property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "EXADATA_CC"
    DEPLOYMENT_TYPE_EXADATA_CC = "EXADATA_CC"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "FULL"
    RACK_SIZE_FULL = "FULL"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "HALF"
    RACK_SIZE_HALF = "HALF"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "QUARTER"
    RACK_SIZE_QUARTER = "QUARTER"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "EIGHTH"
    RACK_SIZE_EIGHTH = "EIGHTH"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureUsageMetrics.
    #: This constant has a value of "OTHER"
    RACK_SIZE_OTHER = "OTHER"

    def __init__(self, **kwargs):
        """
        Initializes a new ExadataInfrastructureUsageMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param infrastructure_id:
            The value to assign to the infrastructure_id property of this ExadataInfrastructureUsageMetrics.
        :type infrastructure_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ExadataInfrastructureUsageMetrics.
        :type compartment_id: str

        :param deployment_type:
            The value to assign to the deployment_type property of this ExadataInfrastructureUsageMetrics.
            Allowed values for this property are: "ONPREMISE", "EXADATA", "EXADATA_CC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_type: str

        :param infrastructure_name:
            The value to assign to the infrastructure_name property of this ExadataInfrastructureUsageMetrics.
        :type infrastructure_name: str

        :param state:
            The value to assign to the state property of this ExadataInfrastructureUsageMetrics.
        :type state: str

        :param number_of_db_systems:
            The value to assign to the number_of_db_systems property of this ExadataInfrastructureUsageMetrics.
        :type number_of_db_systems: int

        :param rack_size:
            The value to assign to the rack_size property of this ExadataInfrastructureUsageMetrics.
            Allowed values for this property are: "FULL", "HALF", "QUARTER", "EIGHTH", "OTHER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type rack_size: str

        :param storage_server_count:
            The value to assign to the storage_server_count property of this ExadataInfrastructureUsageMetrics.
        :type storage_server_count: int

        :param metrics:
            The value to assign to the metrics property of this ExadataInfrastructureUsageMetrics.
        :type metrics: list[oci.database_management.models.ExadataFleetMetricDefinition]

        """
        self.swagger_types = {
            'infrastructure_id': 'str',
            'compartment_id': 'str',
            'deployment_type': 'str',
            'infrastructure_name': 'str',
            'state': 'str',
            'number_of_db_systems': 'int',
            'rack_size': 'str',
            'storage_server_count': 'int',
            'metrics': 'list[ExadataFleetMetricDefinition]'
        }
        self.attribute_map = {
            'infrastructure_id': 'infrastructureId',
            'compartment_id': 'compartmentId',
            'deployment_type': 'deploymentType',
            'infrastructure_name': 'infrastructureName',
            'state': 'state',
            'number_of_db_systems': 'numberOfDbSystems',
            'rack_size': 'rackSize',
            'storage_server_count': 'storageServerCount',
            'metrics': 'metrics'
        }
        self._infrastructure_id = None
        self._compartment_id = None
        self._deployment_type = None
        self._infrastructure_name = None
        self._state = None
        self._number_of_db_systems = None
        self._rack_size = None
        self._storage_server_count = None
        self._metrics = None

    @property
    def infrastructure_id(self):
        """
        Gets the infrastructure_id of this ExadataInfrastructureUsageMetrics.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The infrastructure_id of this ExadataInfrastructureUsageMetrics.
        :rtype: str
        """
        return self._infrastructure_id

    @infrastructure_id.setter
    def infrastructure_id(self, infrastructure_id):
        """
        Sets the infrastructure_id of this ExadataInfrastructureUsageMetrics.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param infrastructure_id: The infrastructure_id of this ExadataInfrastructureUsageMetrics.
        :type: str
        """
        self._infrastructure_id = infrastructure_id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this ExadataInfrastructureUsageMetrics.
        The `OCID`__ of the compartment where the Exadata infrastructure resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ExadataInfrastructureUsageMetrics.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ExadataInfrastructureUsageMetrics.
        The `OCID`__ of the compartment where the Exadata infrastructure resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ExadataInfrastructureUsageMetrics.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def deployment_type(self):
        """
        Gets the deployment_type of this ExadataInfrastructureUsageMetrics.
        The Exadata infrastructure deployment type.

        Allowed values for this property are: "ONPREMISE", "EXADATA", "EXADATA_CC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_type of this ExadataInfrastructureUsageMetrics.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this ExadataInfrastructureUsageMetrics.
        The Exadata infrastructure deployment type.


        :param deployment_type: The deployment_type of this ExadataInfrastructureUsageMetrics.
        :type: str
        """
        allowed_values = ["ONPREMISE", "EXADATA", "EXADATA_CC"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._deployment_type = deployment_type

    @property
    def infrastructure_name(self):
        """
        Gets the infrastructure_name of this ExadataInfrastructureUsageMetrics.
        The display name of the Exadata infrastructure.


        :return: The infrastructure_name of this ExadataInfrastructureUsageMetrics.
        :rtype: str
        """
        return self._infrastructure_name

    @infrastructure_name.setter
    def infrastructure_name(self, infrastructure_name):
        """
        Sets the infrastructure_name of this ExadataInfrastructureUsageMetrics.
        The display name of the Exadata infrastructure.


        :param infrastructure_name: The infrastructure_name of this ExadataInfrastructureUsageMetrics.
        :type: str
        """
        self._infrastructure_name = infrastructure_name

    @property
    def state(self):
        """
        Gets the state of this ExadataInfrastructureUsageMetrics.
        The lifecycle state of the Exadata infrastructure.


        :return: The state of this ExadataInfrastructureUsageMetrics.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ExadataInfrastructureUsageMetrics.
        The lifecycle state of the Exadata infrastructure.


        :param state: The state of this ExadataInfrastructureUsageMetrics.
        :type: str
        """
        self._state = state

    @property
    def number_of_db_systems(self):
        """
        Gets the number_of_db_systems of this ExadataInfrastructureUsageMetrics.
        The number of Database Systems created on the Exadata infrastructure.


        :return: The number_of_db_systems of this ExadataInfrastructureUsageMetrics.
        :rtype: int
        """
        return self._number_of_db_systems

    @number_of_db_systems.setter
    def number_of_db_systems(self, number_of_db_systems):
        """
        Sets the number_of_db_systems of this ExadataInfrastructureUsageMetrics.
        The number of Database Systems created on the Exadata infrastructure.


        :param number_of_db_systems: The number_of_db_systems of this ExadataInfrastructureUsageMetrics.
        :type: int
        """
        self._number_of_db_systems = number_of_db_systems

    @property
    def rack_size(self):
        """
        Gets the rack_size of this ExadataInfrastructureUsageMetrics.
        The size of the Exadata infrastructure.

        Allowed values for this property are: "FULL", "HALF", "QUARTER", "EIGHTH", "OTHER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The rack_size of this ExadataInfrastructureUsageMetrics.
        :rtype: str
        """
        return self._rack_size

    @rack_size.setter
    def rack_size(self, rack_size):
        """
        Sets the rack_size of this ExadataInfrastructureUsageMetrics.
        The size of the Exadata infrastructure.


        :param rack_size: The rack_size of this ExadataInfrastructureUsageMetrics.
        :type: str
        """
        allowed_values = ["FULL", "HALF", "QUARTER", "EIGHTH", "OTHER"]
        if not value_allowed_none_or_none_sentinel(rack_size, allowed_values):
            rack_size = 'UNKNOWN_ENUM_VALUE'
        self._rack_size = rack_size

    @property
    def storage_server_count(self):
        """
        Gets the storage_server_count of this ExadataInfrastructureUsageMetrics.
        The number of storage server for the Exadata infrastructure.


        :return: The storage_server_count of this ExadataInfrastructureUsageMetrics.
        :rtype: int
        """
        return self._storage_server_count

    @storage_server_count.setter
    def storage_server_count(self, storage_server_count):
        """
        Sets the storage_server_count of this ExadataInfrastructureUsageMetrics.
        The number of storage server for the Exadata infrastructure.


        :param storage_server_count: The storage_server_count of this ExadataInfrastructureUsageMetrics.
        :type: int
        """
        self._storage_server_count = storage_server_count

    @property
    def metrics(self):
        """
        Gets the metrics of this ExadataInfrastructureUsageMetrics.
        A list of the health metrics like CPU, Storage, and Memory.


        :return: The metrics of this ExadataInfrastructureUsageMetrics.
        :rtype: list[oci.database_management.models.ExadataFleetMetricDefinition]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this ExadataInfrastructureUsageMetrics.
        A list of the health metrics like CPU, Storage, and Memory.


        :param metrics: The metrics of this ExadataInfrastructureUsageMetrics.
        :type: list[oci.database_management.models.ExadataFleetMetricDefinition]
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
