# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadataInfrastructureFleetStatusByCategory(object):
    """
    The number of Exadata infrastructures in the fleet, grouped by deployment type and rack-size.
    """

    #: A constant which can be used with the deployment_type property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "ONPREMISE"
    DEPLOYMENT_TYPE_ONPREMISE = "ONPREMISE"

    #: A constant which can be used with the deployment_type property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "EXADATA"
    DEPLOYMENT_TYPE_EXADATA = "EXADATA"

    #: A constant which can be used with the deployment_type property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "EXADATA_CC"
    DEPLOYMENT_TYPE_EXADATA_CC = "EXADATA_CC"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "FULL"
    RACK_SIZE_FULL = "FULL"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "HALF"
    RACK_SIZE_HALF = "HALF"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "QUARTER"
    RACK_SIZE_QUARTER = "QUARTER"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "EIGHTH"
    RACK_SIZE_EIGHTH = "EIGHTH"

    #: A constant which can be used with the rack_size property of a ExadataInfrastructureFleetStatusByCategory.
    #: This constant has a value of "OTHER"
    RACK_SIZE_OTHER = "OTHER"

    def __init__(self, **kwargs):
        """
        Initializes a new ExadataInfrastructureFleetStatusByCategory object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param deployment_type:
            The value to assign to the deployment_type property of this ExadataInfrastructureFleetStatusByCategory.
            Allowed values for this property are: "ONPREMISE", "EXADATA", "EXADATA_CC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_type: str

        :param rack_size:
            The value to assign to the rack_size property of this ExadataInfrastructureFleetStatusByCategory.
            Allowed values for this property are: "FULL", "HALF", "QUARTER", "EIGHTH", "OTHER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type rack_size: str

        :param inventory_count:
            The value to assign to the inventory_count property of this ExadataInfrastructureFleetStatusByCategory.
        :type inventory_count: int

        """
        self.swagger_types = {
            'deployment_type': 'str',
            'rack_size': 'str',
            'inventory_count': 'int'
        }
        self.attribute_map = {
            'deployment_type': 'deploymentType',
            'rack_size': 'rackSize',
            'inventory_count': 'inventoryCount'
        }
        self._deployment_type = None
        self._rack_size = None
        self._inventory_count = None

    @property
    def deployment_type(self):
        """
        Gets the deployment_type of this ExadataInfrastructureFleetStatusByCategory.
        The infrastructure deployment type.

        Allowed values for this property are: "ONPREMISE", "EXADATA", "EXADATA_CC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_type of this ExadataInfrastructureFleetStatusByCategory.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this ExadataInfrastructureFleetStatusByCategory.
        The infrastructure deployment type.


        :param deployment_type: The deployment_type of this ExadataInfrastructureFleetStatusByCategory.
        :type: str
        """
        allowed_values = ["ONPREMISE", "EXADATA", "EXADATA_CC"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._deployment_type = deployment_type

    @property
    def rack_size(self):
        """
        Gets the rack_size of this ExadataInfrastructureFleetStatusByCategory.
        The size of the Exadata infrastructure.

        Allowed values for this property are: "FULL", "HALF", "QUARTER", "EIGHTH", "OTHER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The rack_size of this ExadataInfrastructureFleetStatusByCategory.
        :rtype: str
        """
        return self._rack_size

    @rack_size.setter
    def rack_size(self, rack_size):
        """
        Sets the rack_size of this ExadataInfrastructureFleetStatusByCategory.
        The size of the Exadata infrastructure.


        :param rack_size: The rack_size of this ExadataInfrastructureFleetStatusByCategory.
        :type: str
        """
        allowed_values = ["FULL", "HALF", "QUARTER", "EIGHTH", "OTHER"]
        if not value_allowed_none_or_none_sentinel(rack_size, allowed_values):
            rack_size = 'UNKNOWN_ENUM_VALUE'
        self._rack_size = rack_size

    @property
    def inventory_count(self):
        """
        Gets the inventory_count of this ExadataInfrastructureFleetStatusByCategory.
        The number of Exadata infrastructures in the fleet.


        :return: The inventory_count of this ExadataInfrastructureFleetStatusByCategory.
        :rtype: int
        """
        return self._inventory_count

    @inventory_count.setter
    def inventory_count(self, inventory_count):
        """
        Sets the inventory_count of this ExadataInfrastructureFleetStatusByCategory.
        The number of Exadata infrastructures in the fleet.


        :param inventory_count: The inventory_count of this ExadataInfrastructureFleetStatusByCategory.
        :type: int
        """
        self._inventory_count = inventory_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
