# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportTransportableTablespaceDetails(object):
    """
    Details for importing transportable tablespace for an Autonomous AI Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImportTransportableTablespaceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tts_bundle_url:
            The value to assign to the tts_bundle_url property of this ImportTransportableTablespaceDetails.
        :type tts_bundle_url: str

        """
        self.swagger_types = {
            'tts_bundle_url': 'str'
        }
        self.attribute_map = {
            'tts_bundle_url': 'ttsBundleUrl'
        }
        self._tts_bundle_url = None

    @property
    def tts_bundle_url(self):
        """
        **[Required]** Gets the tts_bundle_url of this ImportTransportableTablespaceDetails.
        URL for OCI Storage location for a Transportable Tablespace (TTS) bundle.


        :return: The tts_bundle_url of this ImportTransportableTablespaceDetails.
        :rtype: str
        """
        return self._tts_bundle_url

    @tts_bundle_url.setter
    def tts_bundle_url(self, tts_bundle_url):
        """
        Sets the tts_bundle_url of this ImportTransportableTablespaceDetails.
        URL for OCI Storage location for a Transportable Tablespace (TTS) bundle.


        :param tts_bundle_url: The tts_bundle_url of this ImportTransportableTablespaceDetails.
        :type: str
        """
        self._tts_bundle_url = tts_bundle_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
