# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMaintenanceRunDetails(object):
    """
    Details to schedule Maintenance Run with Latest Release Update along TimeZone File Update for the specified resource.
    """

    #: A constant which can be used with the patching_mode property of a CreateMaintenanceRunDetails.
    #: This constant has a value of "ROLLING"
    PATCHING_MODE_ROLLING = "ROLLING"

    #: A constant which can be used with the patching_mode property of a CreateMaintenanceRunDetails.
    #: This constant has a value of "NONROLLING"
    PATCHING_MODE_NONROLLING = "NONROLLING"

    #: A constant which can be used with the patch_type property of a CreateMaintenanceRunDetails.
    #: This constant has a value of "QUARTERLY"
    PATCH_TYPE_QUARTERLY = "QUARTERLY"

    #: A constant which can be used with the patch_type property of a CreateMaintenanceRunDetails.
    #: This constant has a value of "TIMEZONE"
    PATCH_TYPE_TIMEZONE = "TIMEZONE"

    #: A constant which can be used with the patch_type property of a CreateMaintenanceRunDetails.
    #: This constant has a value of "CUSTOM_DATABASE_SOFTWARE_IMAGE"
    PATCH_TYPE_CUSTOM_DATABASE_SOFTWARE_IMAGE = "CUSTOM_DATABASE_SOFTWARE_IMAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMaintenanceRunDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_resource_id:
            The value to assign to the target_resource_id property of this CreateMaintenanceRunDetails.
        :type target_resource_id: str

        :param is_dst_file_update_enabled:
            The value to assign to the is_dst_file_update_enabled property of this CreateMaintenanceRunDetails.
        :type is_dst_file_update_enabled: bool

        :param time_scheduled:
            The value to assign to the time_scheduled property of this CreateMaintenanceRunDetails.
        :type time_scheduled: datetime

        :param patching_mode:
            The value to assign to the patching_mode property of this CreateMaintenanceRunDetails.
            Allowed values for this property are: "ROLLING", "NONROLLING"
        :type patching_mode: str

        :param patch_type:
            The value to assign to the patch_type property of this CreateMaintenanceRunDetails.
            Allowed values for this property are: "QUARTERLY", "TIMEZONE", "CUSTOM_DATABASE_SOFTWARE_IMAGE"
        :type patch_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMaintenanceRunDetails.
        :type compartment_id: str

        :param database_software_image_id:
            The value to assign to the database_software_image_id property of this CreateMaintenanceRunDetails.
        :type database_software_image_id: str

        """
        self.swagger_types = {
            'target_resource_id': 'str',
            'is_dst_file_update_enabled': 'bool',
            'time_scheduled': 'datetime',
            'patching_mode': 'str',
            'patch_type': 'str',
            'compartment_id': 'str',
            'database_software_image_id': 'str'
        }
        self.attribute_map = {
            'target_resource_id': 'targetResourceId',
            'is_dst_file_update_enabled': 'isDstFileUpdateEnabled',
            'time_scheduled': 'timeScheduled',
            'patching_mode': 'patchingMode',
            'patch_type': 'patchType',
            'compartment_id': 'compartmentId',
            'database_software_image_id': 'databaseSoftwareImageId'
        }
        self._target_resource_id = None
        self._is_dst_file_update_enabled = None
        self._time_scheduled = None
        self._patching_mode = None
        self._patch_type = None
        self._compartment_id = None
        self._database_software_image_id = None

    @property
    def target_resource_id(self):
        """
        **[Required]** Gets the target_resource_id of this CreateMaintenanceRunDetails.
        The ID of the target resource for which the maintenance run should be created.


        :return: The target_resource_id of this CreateMaintenanceRunDetails.
        :rtype: str
        """
        return self._target_resource_id

    @target_resource_id.setter
    def target_resource_id(self, target_resource_id):
        """
        Sets the target_resource_id of this CreateMaintenanceRunDetails.
        The ID of the target resource for which the maintenance run should be created.


        :param target_resource_id: The target_resource_id of this CreateMaintenanceRunDetails.
        :type: str
        """
        self._target_resource_id = target_resource_id

    @property
    def is_dst_file_update_enabled(self):
        """
        Gets the is_dst_file_update_enabled of this CreateMaintenanceRunDetails.
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.


        :return: The is_dst_file_update_enabled of this CreateMaintenanceRunDetails.
        :rtype: bool
        """
        return self._is_dst_file_update_enabled

    @is_dst_file_update_enabled.setter
    def is_dst_file_update_enabled(self, is_dst_file_update_enabled):
        """
        Sets the is_dst_file_update_enabled of this CreateMaintenanceRunDetails.
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.


        :param is_dst_file_update_enabled: The is_dst_file_update_enabled of this CreateMaintenanceRunDetails.
        :type: bool
        """
        self._is_dst_file_update_enabled = is_dst_file_update_enabled

    @property
    def time_scheduled(self):
        """
        **[Required]** Gets the time_scheduled of this CreateMaintenanceRunDetails.
        The date and time that update should be scheduled.


        :return: The time_scheduled of this CreateMaintenanceRunDetails.
        :rtype: datetime
        """
        return self._time_scheduled

    @time_scheduled.setter
    def time_scheduled(self, time_scheduled):
        """
        Sets the time_scheduled of this CreateMaintenanceRunDetails.
        The date and time that update should be scheduled.


        :param time_scheduled: The time_scheduled of this CreateMaintenanceRunDetails.
        :type: datetime
        """
        self._time_scheduled = time_scheduled

    @property
    def patching_mode(self):
        """
        Gets the patching_mode of this CreateMaintenanceRunDetails.
        Cloud Exadata infrastructure node patching method, either \"ROLLING\" or \"NONROLLING\". Default value is ROLLING.

        *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See `Oracle-Managed Infrastructure Maintenance Updates`__ for more information.

        __ https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle

        Allowed values for this property are: "ROLLING", "NONROLLING"


        :return: The patching_mode of this CreateMaintenanceRunDetails.
        :rtype: str
        """
        return self._patching_mode

    @patching_mode.setter
    def patching_mode(self, patching_mode):
        """
        Sets the patching_mode of this CreateMaintenanceRunDetails.
        Cloud Exadata infrastructure node patching method, either \"ROLLING\" or \"NONROLLING\". Default value is ROLLING.

        *IMPORTANT*: Non-rolling infrastructure patching involves system down time. See `Oracle-Managed Infrastructure Maintenance Updates`__ for more information.

        __ https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/examaintenance.htm#Oracle


        :param patching_mode: The patching_mode of this CreateMaintenanceRunDetails.
        :type: str
        """
        allowed_values = ["ROLLING", "NONROLLING"]
        if not value_allowed_none_or_none_sentinel(patching_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `patching_mode`, must be None or one of {allowed_values}"
            )
        self._patching_mode = patching_mode

    @property
    def patch_type(self):
        """
        **[Required]** Gets the patch_type of this CreateMaintenanceRunDetails.
        Patch type, either \"QUARTERLY\", \"TIMEZONE\" or \"CUSTOM_DATABASE_SOFTWARE_IMAGE\".

        Allowed values for this property are: "QUARTERLY", "TIMEZONE", "CUSTOM_DATABASE_SOFTWARE_IMAGE"


        :return: The patch_type of this CreateMaintenanceRunDetails.
        :rtype: str
        """
        return self._patch_type

    @patch_type.setter
    def patch_type(self, patch_type):
        """
        Sets the patch_type of this CreateMaintenanceRunDetails.
        Patch type, either \"QUARTERLY\", \"TIMEZONE\" or \"CUSTOM_DATABASE_SOFTWARE_IMAGE\".


        :param patch_type: The patch_type of this CreateMaintenanceRunDetails.
        :type: str
        """
        allowed_values = ["QUARTERLY", "TIMEZONE", "CUSTOM_DATABASE_SOFTWARE_IMAGE"]
        if not value_allowed_none_or_none_sentinel(patch_type, allowed_values):
            raise ValueError(
                f"Invalid value for `patch_type`, must be None or one of {allowed_values}"
            )
        self._patch_type = patch_type

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreateMaintenanceRunDetails.
        The `OCID`__ of the compartment containing the Maintenance Run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateMaintenanceRunDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateMaintenanceRunDetails.
        The `OCID`__ of the compartment containing the Maintenance Run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateMaintenanceRunDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def database_software_image_id(self):
        """
        Gets the database_software_image_id of this CreateMaintenanceRunDetails.
        The Autonomous AI Database Software Image `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The database_software_image_id of this CreateMaintenanceRunDetails.
        :rtype: str
        """
        return self._database_software_image_id

    @database_software_image_id.setter
    def database_software_image_id(self, database_software_image_id):
        """
        Sets the database_software_image_id of this CreateMaintenanceRunDetails.
        The Autonomous AI Database Software Image `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param database_software_image_id: The database_software_image_id of this CreateMaintenanceRunDetails.
        :type: str
        """
        self._database_software_image_id = database_software_image_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
