# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateExascaleDbStorageVaultDetails(object):
    """
    Details to create a Exadata Database Storage Vault.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateExascaleDbStorageVaultDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateExascaleDbStorageVaultDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateExascaleDbStorageVaultDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateExascaleDbStorageVaultDetails.
        :type description: str

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateExascaleDbStorageVaultDetails.
        :type availability_domain: str

        :param time_zone:
            The value to assign to the time_zone property of this CreateExascaleDbStorageVaultDetails.
        :type time_zone: str

        :param high_capacity_database_storage:
            The value to assign to the high_capacity_database_storage property of this CreateExascaleDbStorageVaultDetails.
        :type high_capacity_database_storage: oci.database.models.ExascaleDbStorageInputDetails

        :param additional_flash_cache_in_percent:
            The value to assign to the additional_flash_cache_in_percent property of this CreateExascaleDbStorageVaultDetails.
        :type additional_flash_cache_in_percent: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateExascaleDbStorageVaultDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateExascaleDbStorageVaultDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param exadata_infrastructure_id:
            The value to assign to the exadata_infrastructure_id property of this CreateExascaleDbStorageVaultDetails.
        :type exadata_infrastructure_id: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this CreateExascaleDbStorageVaultDetails.
        :type cluster_placement_group_id: str

        :param subscription_id:
            The value to assign to the subscription_id property of this CreateExascaleDbStorageVaultDetails.
        :type subscription_id: str

        :param is_autoscale_enabled:
            The value to assign to the is_autoscale_enabled property of this CreateExascaleDbStorageVaultDetails.
        :type is_autoscale_enabled: bool

        :param autoscale_limit_in_gbs:
            The value to assign to the autoscale_limit_in_gbs property of this CreateExascaleDbStorageVaultDetails.
        :type autoscale_limit_in_gbs: int

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'availability_domain': 'str',
            'time_zone': 'str',
            'high_capacity_database_storage': 'ExascaleDbStorageInputDetails',
            'additional_flash_cache_in_percent': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'exadata_infrastructure_id': 'str',
            'cluster_placement_group_id': 'str',
            'subscription_id': 'str',
            'is_autoscale_enabled': 'bool',
            'autoscale_limit_in_gbs': 'int'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'availability_domain': 'availabilityDomain',
            'time_zone': 'timeZone',
            'high_capacity_database_storage': 'highCapacityDatabaseStorage',
            'additional_flash_cache_in_percent': 'additionalFlashCacheInPercent',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'exadata_infrastructure_id': 'exadataInfrastructureId',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'subscription_id': 'subscriptionId',
            'is_autoscale_enabled': 'isAutoscaleEnabled',
            'autoscale_limit_in_gbs': 'autoscaleLimitInGBs'
        }
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._availability_domain = None
        self._time_zone = None
        self._high_capacity_database_storage = None
        self._additional_flash_cache_in_percent = None
        self._freeform_tags = None
        self._defined_tags = None
        self._exadata_infrastructure_id = None
        self._cluster_placement_group_id = None
        self._subscription_id = None
        self._is_autoscale_enabled = None
        self._autoscale_limit_in_gbs = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateExascaleDbStorageVaultDetails.
        The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.


        :return: The display_name of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateExascaleDbStorageVaultDetails.
        The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.


        :param display_name: The display_name of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateExascaleDbStorageVaultDetails.
        Exadata Database Storage Vault description.


        :return: The description of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateExascaleDbStorageVaultDetails.
        Exadata Database Storage Vault description.


        :param description: The description of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._description = description

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateExascaleDbStorageVaultDetails.
        The name of the availability domain in which the Exadata Database Storage Vault is located.


        :return: The availability_domain of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateExascaleDbStorageVaultDetails.
        The name of the availability domain in which the Exadata Database Storage Vault is located.


        :param availability_domain: The availability_domain of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def time_zone(self):
        """
        Gets the time_zone of this CreateExascaleDbStorageVaultDetails.
        The time zone that you want to use for the Exadata Database Storage Vault. For details, see `Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :return: The time_zone of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """
        Sets the time_zone of this CreateExascaleDbStorageVaultDetails.
        The time zone that you want to use for the Exadata Database Storage Vault. For details, see `Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :param time_zone: The time_zone of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._time_zone = time_zone

    @property
    def high_capacity_database_storage(self):
        """
        **[Required]** Gets the high_capacity_database_storage of this CreateExascaleDbStorageVaultDetails.

        :return: The high_capacity_database_storage of this CreateExascaleDbStorageVaultDetails.
        :rtype: oci.database.models.ExascaleDbStorageInputDetails
        """
        return self._high_capacity_database_storage

    @high_capacity_database_storage.setter
    def high_capacity_database_storage(self, high_capacity_database_storage):
        """
        Sets the high_capacity_database_storage of this CreateExascaleDbStorageVaultDetails.

        :param high_capacity_database_storage: The high_capacity_database_storage of this CreateExascaleDbStorageVaultDetails.
        :type: oci.database.models.ExascaleDbStorageInputDetails
        """
        self._high_capacity_database_storage = high_capacity_database_storage

    @property
    def additional_flash_cache_in_percent(self):
        """
        Gets the additional_flash_cache_in_percent of this CreateExascaleDbStorageVaultDetails.
        The size of additional Flash Cache in percentage of High Capacity database storage.


        :return: The additional_flash_cache_in_percent of this CreateExascaleDbStorageVaultDetails.
        :rtype: int
        """
        return self._additional_flash_cache_in_percent

    @additional_flash_cache_in_percent.setter
    def additional_flash_cache_in_percent(self, additional_flash_cache_in_percent):
        """
        Sets the additional_flash_cache_in_percent of this CreateExascaleDbStorageVaultDetails.
        The size of additional Flash Cache in percentage of High Capacity database storage.


        :param additional_flash_cache_in_percent: The additional_flash_cache_in_percent of this CreateExascaleDbStorageVaultDetails.
        :type: int
        """
        self._additional_flash_cache_in_percent = additional_flash_cache_in_percent

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateExascaleDbStorageVaultDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateExascaleDbStorageVaultDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateExascaleDbStorageVaultDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateExascaleDbStorageVaultDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateExascaleDbStorageVaultDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateExascaleDbStorageVaultDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateExascaleDbStorageVaultDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateExascaleDbStorageVaultDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def exadata_infrastructure_id(self):
        """
        Gets the exadata_infrastructure_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The exadata_infrastructure_id of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._exadata_infrastructure_id

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, exadata_infrastructure_id):
        """
        Sets the exadata_infrastructure_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param exadata_infrastructure_id: The exadata_infrastructure_id of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._exadata_infrastructure_id = exadata_infrastructure_id

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the cluster placement group of the Exadata Infrastructure or Db System.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cluster_placement_group_id of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the cluster placement group of the Exadata Infrastructure or Db System.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cluster_placement_group_id: The cluster_placement_group_id of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def subscription_id(self):
        """
        Gets the subscription_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subscription_id of this CreateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """
        Sets the subscription_id of this CreateExascaleDbStorageVaultDetails.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subscription_id: The subscription_id of this CreateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._subscription_id = subscription_id

    @property
    def is_autoscale_enabled(self):
        """
        Gets the is_autoscale_enabled of this CreateExascaleDbStorageVaultDetails.
        Indicates if autoscale feature is enabled for the Database Storage Vault. The default value is `FALSE`.


        :return: The is_autoscale_enabled of this CreateExascaleDbStorageVaultDetails.
        :rtype: bool
        """
        return self._is_autoscale_enabled

    @is_autoscale_enabled.setter
    def is_autoscale_enabled(self, is_autoscale_enabled):
        """
        Sets the is_autoscale_enabled of this CreateExascaleDbStorageVaultDetails.
        Indicates if autoscale feature is enabled for the Database Storage Vault. The default value is `FALSE`.


        :param is_autoscale_enabled: The is_autoscale_enabled of this CreateExascaleDbStorageVaultDetails.
        :type: bool
        """
        self._is_autoscale_enabled = is_autoscale_enabled

    @property
    def autoscale_limit_in_gbs(self):
        """
        Gets the autoscale_limit_in_gbs of this CreateExascaleDbStorageVaultDetails.
        The maximum limit, in gigabytes, to which the Vault storage size can automatically scale when auto scaling is enabled for the Database Storage Vault


        :return: The autoscale_limit_in_gbs of this CreateExascaleDbStorageVaultDetails.
        :rtype: int
        """
        return self._autoscale_limit_in_gbs

    @autoscale_limit_in_gbs.setter
    def autoscale_limit_in_gbs(self, autoscale_limit_in_gbs):
        """
        Sets the autoscale_limit_in_gbs of this CreateExascaleDbStorageVaultDetails.
        The maximum limit, in gigabytes, to which the Vault storage size can automatically scale when auto scaling is enabled for the Database Storage Vault


        :param autoscale_limit_in_gbs: The autoscale_limit_in_gbs of this CreateExascaleDbStorageVaultDetails.
        :type: int
        """
        self._autoscale_limit_in_gbs = autoscale_limit_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
