# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDatabaseFromAnotherDatabaseDetails(object):
    """
    CreateDatabaseFromAnotherDatabaseDetails model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDatabaseFromAnotherDatabaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_id:
            The value to assign to the database_id property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type database_id: str

        :param backup_tde_password:
            The value to assign to the backup_tde_password property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type backup_tde_password: str

        :param admin_password:
            The value to assign to the admin_password property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type admin_password: str

        :param db_unique_name:
            The value to assign to the db_unique_name property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type db_unique_name: str

        :param db_name:
            The value to assign to the db_name property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type db_name: str

        :param time_stamp_for_point_in_time_recovery:
            The value to assign to the time_stamp_for_point_in_time_recovery property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type time_stamp_for_point_in_time_recovery: datetime

        :param pluggable_databases:
            The value to assign to the pluggable_databases property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type pluggable_databases: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param sid_prefix:
            The value to assign to the sid_prefix property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type sid_prefix: str

        :param source_encryption_key_location_details:
            The value to assign to the source_encryption_key_location_details property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type source_encryption_key_location_details: oci.database.models.EncryptionKeyLocationDetails

        :param storage_size_details:
            The value to assign to the storage_size_details property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type storage_size_details: oci.database.models.DatabaseStorageSizeDetails

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this CreateDatabaseFromAnotherDatabaseDetails.
        :type vm_cluster_id: str

        """
        self.swagger_types = {
            'database_id': 'str',
            'backup_tde_password': 'str',
            'admin_password': 'str',
            'db_unique_name': 'str',
            'db_name': 'str',
            'time_stamp_for_point_in_time_recovery': 'datetime',
            'pluggable_databases': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'sid_prefix': 'str',
            'source_encryption_key_location_details': 'EncryptionKeyLocationDetails',
            'storage_size_details': 'DatabaseStorageSizeDetails',
            'vm_cluster_id': 'str'
        }
        self.attribute_map = {
            'database_id': 'databaseId',
            'backup_tde_password': 'backupTDEPassword',
            'admin_password': 'adminPassword',
            'db_unique_name': 'dbUniqueName',
            'db_name': 'dbName',
            'time_stamp_for_point_in_time_recovery': 'timeStampForPointInTimeRecovery',
            'pluggable_databases': 'pluggableDatabases',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'sid_prefix': 'sidPrefix',
            'source_encryption_key_location_details': 'sourceEncryptionKeyLocationDetails',
            'storage_size_details': 'storageSizeDetails',
            'vm_cluster_id': 'vmClusterId'
        }
        self._database_id = None
        self._backup_tde_password = None
        self._admin_password = None
        self._db_unique_name = None
        self._db_name = None
        self._time_stamp_for_point_in_time_recovery = None
        self._pluggable_databases = None
        self._freeform_tags = None
        self._defined_tags = None
        self._sid_prefix = None
        self._source_encryption_key_location_details = None
        self._storage_size_details = None
        self._vm_cluster_id = None

    @property
    def database_id(self):
        """
        **[Required]** Gets the database_id of this CreateDatabaseFromAnotherDatabaseDetails.
        The database `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The database_id of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this CreateDatabaseFromAnotherDatabaseDetails.
        The database `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param database_id: The database_id of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: str
        """
        self._database_id = database_id

    @property
    def backup_tde_password(self):
        """
        Gets the backup_tde_password of this CreateDatabaseFromAnotherDatabaseDetails.
        The password to open the TDE wallet.


        :return: The backup_tde_password of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: str
        """
        return self._backup_tde_password

    @backup_tde_password.setter
    def backup_tde_password(self, backup_tde_password):
        """
        Sets the backup_tde_password of this CreateDatabaseFromAnotherDatabaseDetails.
        The password to open the TDE wallet.


        :param backup_tde_password: The backup_tde_password of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: str
        """
        self._backup_tde_password = backup_tde_password

    @property
    def admin_password(self):
        """
        **[Required]** Gets the admin_password of this CreateDatabaseFromAnotherDatabaseDetails.
        A strong password for SYS, SYSTEM, PDB Admin and TDE Wallet. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.


        :return: The admin_password of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this CreateDatabaseFromAnotherDatabaseDetails.
        A strong password for SYS, SYSTEM, PDB Admin and TDE Wallet. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.


        :param admin_password: The admin_password of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def db_unique_name(self):
        """
        Gets the db_unique_name of this CreateDatabaseFromAnotherDatabaseDetails.
        The `DB_UNIQUE_NAME` of the Oracle Database being backed up.


        :return: The db_unique_name of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: str
        """
        return self._db_unique_name

    @db_unique_name.setter
    def db_unique_name(self, db_unique_name):
        """
        Sets the db_unique_name of this CreateDatabaseFromAnotherDatabaseDetails.
        The `DB_UNIQUE_NAME` of the Oracle Database being backed up.


        :param db_unique_name: The db_unique_name of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: str
        """
        self._db_unique_name = db_unique_name

    @property
    def db_name(self):
        """
        Gets the db_name of this CreateDatabaseFromAnotherDatabaseDetails.
        The display name of the database to be created from the backup. It must begin with an alphabetic character and can contain a maximum of eight alphanumeric characters. Special characters are not permitted.


        :return: The db_name of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: str
        """
        return self._db_name

    @db_name.setter
    def db_name(self, db_name):
        """
        Sets the db_name of this CreateDatabaseFromAnotherDatabaseDetails.
        The display name of the database to be created from the backup. It must begin with an alphabetic character and can contain a maximum of eight alphanumeric characters. Special characters are not permitted.


        :param db_name: The db_name of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: str
        """
        self._db_name = db_name

    @property
    def time_stamp_for_point_in_time_recovery(self):
        """
        Gets the time_stamp_for_point_in_time_recovery of this CreateDatabaseFromAnotherDatabaseDetails.
        The point in time of the original database from which the new database is created. If not specifed, the latest backup is used to create the database.


        :return: The time_stamp_for_point_in_time_recovery of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: datetime
        """
        return self._time_stamp_for_point_in_time_recovery

    @time_stamp_for_point_in_time_recovery.setter
    def time_stamp_for_point_in_time_recovery(self, time_stamp_for_point_in_time_recovery):
        """
        Sets the time_stamp_for_point_in_time_recovery of this CreateDatabaseFromAnotherDatabaseDetails.
        The point in time of the original database from which the new database is created. If not specifed, the latest backup is used to create the database.


        :param time_stamp_for_point_in_time_recovery: The time_stamp_for_point_in_time_recovery of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: datetime
        """
        self._time_stamp_for_point_in_time_recovery = time_stamp_for_point_in_time_recovery

    @property
    def pluggable_databases(self):
        """
        Gets the pluggable_databases of this CreateDatabaseFromAnotherDatabaseDetails.
        The list of pluggable databases that needs to be restored into new database.


        :return: The pluggable_databases of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: list[str]
        """
        return self._pluggable_databases

    @pluggable_databases.setter
    def pluggable_databases(self, pluggable_databases):
        """
        Sets the pluggable_databases of this CreateDatabaseFromAnotherDatabaseDetails.
        The list of pluggable databases that needs to be restored into new database.


        :param pluggable_databases: The pluggable_databases of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: list[str]
        """
        self._pluggable_databases = pluggable_databases

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def sid_prefix(self):
        """
        Gets the sid_prefix of this CreateDatabaseFromAnotherDatabaseDetails.
        Specifies a prefix for the `Oracle SID` of the database to be created.


        :return: The sid_prefix of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: str
        """
        return self._sid_prefix

    @sid_prefix.setter
    def sid_prefix(self, sid_prefix):
        """
        Sets the sid_prefix of this CreateDatabaseFromAnotherDatabaseDetails.
        Specifies a prefix for the `Oracle SID` of the database to be created.


        :param sid_prefix: The sid_prefix of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: str
        """
        self._sid_prefix = sid_prefix

    @property
    def source_encryption_key_location_details(self):
        """
        Gets the source_encryption_key_location_details of this CreateDatabaseFromAnotherDatabaseDetails.

        :return: The source_encryption_key_location_details of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: oci.database.models.EncryptionKeyLocationDetails
        """
        return self._source_encryption_key_location_details

    @source_encryption_key_location_details.setter
    def source_encryption_key_location_details(self, source_encryption_key_location_details):
        """
        Sets the source_encryption_key_location_details of this CreateDatabaseFromAnotherDatabaseDetails.

        :param source_encryption_key_location_details: The source_encryption_key_location_details of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: oci.database.models.EncryptionKeyLocationDetails
        """
        self._source_encryption_key_location_details = source_encryption_key_location_details

    @property
    def storage_size_details(self):
        """
        Gets the storage_size_details of this CreateDatabaseFromAnotherDatabaseDetails.

        :return: The storage_size_details of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: oci.database.models.DatabaseStorageSizeDetails
        """
        return self._storage_size_details

    @storage_size_details.setter
    def storage_size_details(self, storage_size_details):
        """
        Sets the storage_size_details of this CreateDatabaseFromAnotherDatabaseDetails.

        :param storage_size_details: The storage_size_details of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: oci.database.models.DatabaseStorageSizeDetails
        """
        self._storage_size_details = storage_size_details

    @property
    def vm_cluster_id(self):
        """
        Gets the vm_cluster_id of this CreateDatabaseFromAnotherDatabaseDetails.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_id of this CreateDatabaseFromAnotherDatabaseDetails.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this CreateDatabaseFromAnotherDatabaseDetails.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_id: The vm_cluster_id of this CreateDatabaseFromAnotherDatabaseDetails.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
