# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConvertStandbyDatabaseTypeDetails(object):
    """
    The convertStandbyDatabaseType request parameters.
    """

    #: A constant which can be used with the standby_conversion_type property of a ConvertStandbyDatabaseTypeDetails.
    #: This constant has a value of "SNAPSHOT"
    STANDBY_CONVERSION_TYPE_SNAPSHOT = "SNAPSHOT"

    #: A constant which can be used with the standby_conversion_type property of a ConvertStandbyDatabaseTypeDetails.
    #: This constant has a value of "PHYSICAL"
    STANDBY_CONVERSION_TYPE_PHYSICAL = "PHYSICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new ConvertStandbyDatabaseTypeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_admin_password:
            The value to assign to the database_admin_password property of this ConvertStandbyDatabaseTypeDetails.
        :type database_admin_password: str

        :param standby_conversion_type:
            The value to assign to the standby_conversion_type property of this ConvertStandbyDatabaseTypeDetails.
            Allowed values for this property are: "SNAPSHOT", "PHYSICAL"
        :type standby_conversion_type: str

        :param snapshot_duration_in_days:
            The value to assign to the snapshot_duration_in_days property of this ConvertStandbyDatabaseTypeDetails.
        :type snapshot_duration_in_days: int

        """
        self.swagger_types = {
            'database_admin_password': 'str',
            'standby_conversion_type': 'str',
            'snapshot_duration_in_days': 'int'
        }
        self.attribute_map = {
            'database_admin_password': 'databaseAdminPassword',
            'standby_conversion_type': 'standbyConversionType',
            'snapshot_duration_in_days': 'snapshotDurationInDays'
        }
        self._database_admin_password = None
        self._standby_conversion_type = None
        self._snapshot_duration_in_days = None

    @property
    def database_admin_password(self):
        """
        **[Required]** Gets the database_admin_password of this ConvertStandbyDatabaseTypeDetails.
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**


        :return: The database_admin_password of this ConvertStandbyDatabaseTypeDetails.
        :rtype: str
        """
        return self._database_admin_password

    @database_admin_password.setter
    def database_admin_password(self, database_admin_password):
        """
        Sets the database_admin_password of this ConvertStandbyDatabaseTypeDetails.
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**


        :param database_admin_password: The database_admin_password of this ConvertStandbyDatabaseTypeDetails.
        :type: str
        """
        self._database_admin_password = database_admin_password

    @property
    def standby_conversion_type(self):
        """
        **[Required]** Gets the standby_conversion_type of this ConvertStandbyDatabaseTypeDetails.
        Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.

        Valid standbyConversionType:
            - SNAPSHOT
            - PHYSICAL

        Allowed values for this property are: "SNAPSHOT", "PHYSICAL"


        :return: The standby_conversion_type of this ConvertStandbyDatabaseTypeDetails.
        :rtype: str
        """
        return self._standby_conversion_type

    @standby_conversion_type.setter
    def standby_conversion_type(self, standby_conversion_type):
        """
        Sets the standby_conversion_type of this ConvertStandbyDatabaseTypeDetails.
        Defines the conversion type of the standby database. Specify this to convert a physical standby to a snapshot standby and vice versa.

        Valid standbyConversionType:
            - SNAPSHOT
            - PHYSICAL


        :param standby_conversion_type: The standby_conversion_type of this ConvertStandbyDatabaseTypeDetails.
        :type: str
        """
        allowed_values = ["SNAPSHOT", "PHYSICAL"]
        if not value_allowed_none_or_none_sentinel(standby_conversion_type, allowed_values):
            raise ValueError(
                f"Invalid value for `standby_conversion_type`, must be None or one of {allowed_values}"
            )
        self._standby_conversion_type = standby_conversion_type

    @property
    def snapshot_duration_in_days(self):
        """
        Gets the snapshot_duration_in_days of this ConvertStandbyDatabaseTypeDetails.
        SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby.
        The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.

        This field is only applicable if the requested database role is snapshot standby.


        :return: The snapshot_duration_in_days of this ConvertStandbyDatabaseTypeDetails.
        :rtype: int
        """
        return self._snapshot_duration_in_days

    @snapshot_duration_in_days.setter
    def snapshot_duration_in_days(self, snapshot_duration_in_days):
        """
        Sets the snapshot_duration_in_days of this ConvertStandbyDatabaseTypeDetails.
        SnapshotDurationInDays is the duration in day(s) after which the Snapshot Standby Database will get converted back to Physical Standby.
        The minimum value of snapshotDurationInDays is 3 days and maximum value is 14 days. Default value will be 7 days if not provided in the Request.

        This field is only applicable if the requested database role is snapshot standby.


        :param snapshot_duration_in_days: The snapshot_duration_in_days of this ConvertStandbyDatabaseTypeDetails.
        :type: int
        """
        self._snapshot_duration_in_days = snapshot_duration_in_days

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
