# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduleTrigger(object):
    """
    The trigger of the schedule can be UNIX cron or iCal expression or simple interval
    """

    #: A constant which can be used with the trigger_type property of a ScheduleTrigger.
    #: This constant has a value of "CRON"
    TRIGGER_TYPE_CRON = "CRON"

    #: A constant which can be used with the trigger_type property of a ScheduleTrigger.
    #: This constant has a value of "INTERVAL"
    TRIGGER_TYPE_INTERVAL = "INTERVAL"

    #: A constant which can be used with the trigger_type property of a ScheduleTrigger.
    #: This constant has a value of "ICAL"
    TRIGGER_TYPE_ICAL = "ICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduleTrigger object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.ScheduleICalTrigger`
        * :class:`~oci.data_science.models.ScheduleIntervalTrigger`
        * :class:`~oci.data_science.models.ScheduleCronTrigger`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param trigger_type:
            The value to assign to the trigger_type property of this ScheduleTrigger.
            Allowed values for this property are: "CRON", "INTERVAL", "ICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type trigger_type: str

        :param time_start:
            The value to assign to the time_start property of this ScheduleTrigger.
        :type time_start: datetime

        :param time_end:
            The value to assign to the time_end property of this ScheduleTrigger.
        :type time_end: datetime

        """
        self.swagger_types = {
            'trigger_type': 'str',
            'time_start': 'datetime',
            'time_end': 'datetime'
        }
        self.attribute_map = {
            'trigger_type': 'triggerType',
            'time_start': 'timeStart',
            'time_end': 'timeEnd'
        }
        self._trigger_type = None
        self._time_start = None
        self._time_end = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['triggerType']

        if type == 'ICAL':
            return 'ScheduleICalTrigger'

        if type == 'INTERVAL':
            return 'ScheduleIntervalTrigger'

        if type == 'CRON':
            return 'ScheduleCronTrigger'
        else:
            return 'ScheduleTrigger'

    @property
    def trigger_type(self):
        """
        **[Required]** Gets the trigger_type of this ScheduleTrigger.
        The schedule trigger type

        Allowed values for this property are: "CRON", "INTERVAL", "ICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The trigger_type of this ScheduleTrigger.
        :rtype: str
        """
        return self._trigger_type

    @trigger_type.setter
    def trigger_type(self, trigger_type):
        """
        Sets the trigger_type of this ScheduleTrigger.
        The schedule trigger type


        :param trigger_type: The trigger_type of this ScheduleTrigger.
        :type: str
        """
        allowed_values = ["CRON", "INTERVAL", "ICAL"]
        if not value_allowed_none_or_none_sentinel(trigger_type, allowed_values):
            trigger_type = 'UNKNOWN_ENUM_VALUE'
        self._trigger_type = trigger_type

    @property
    def time_start(self):
        """
        Gets the time_start of this ScheduleTrigger.
        The schedule starting date time, if null, System set the time when schedule is created.
        Format is defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_start of this ScheduleTrigger.
        :rtype: datetime
        """
        return self._time_start

    @time_start.setter
    def time_start(self, time_start):
        """
        Sets the time_start of this ScheduleTrigger.
        The schedule starting date time, if null, System set the time when schedule is created.
        Format is defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_start: The time_start of this ScheduleTrigger.
        :type: datetime
        """
        self._time_start = time_start

    @property
    def time_end(self):
        """
        Gets the time_end of this ScheduleTrigger.
        The schedule end date time, if null, the schedule will never expire.
        Format is defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_end of this ScheduleTrigger.
        :rtype: datetime
        """
        return self._time_end

    @time_end.setter
    def time_end(self, time_end):
        """
        Sets the time_end of this ScheduleTrigger.
        The schedule end date time, if null, the schedule will never expire.
        Format is defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_end: The time_end of this ScheduleTrigger.
        :type: datetime
        """
        self._time_end = time_end

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
