# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModifyModelGroupDetails(object):
    """
    Overwrites the properties of the source modelGroup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModifyModelGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this ModifyModelGroupDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this ModifyModelGroupDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ModifyModelGroupDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ModifyModelGroupDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param model_group_version_history_id:
            The value to assign to the model_group_version_history_id property of this ModifyModelGroupDetails.
        :type model_group_version_history_id: str

        :param version_label:
            The value to assign to the version_label property of this ModifyModelGroupDetails.
        :type version_label: str

        :param model_group_details:
            The value to assign to the model_group_details property of this ModifyModelGroupDetails.
        :type model_group_details: oci.data_science.models.ModelGroupDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'model_group_version_history_id': 'str',
            'version_label': 'str',
            'model_group_details': 'ModelGroupDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'model_group_version_history_id': 'modelGroupVersionHistoryId',
            'version_label': 'versionLabel',
            'model_group_details': 'modelGroupDetails'
        }
        self._display_name = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._model_group_version_history_id = None
        self._version_label = None
        self._model_group_details = None

    @property
    def display_name(self):
        """
        Gets the display_name of this ModifyModelGroupDetails.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        Example: `My ModelGroup`


        :return: The display_name of this ModifyModelGroupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ModifyModelGroupDetails.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        Example: `My ModelGroup`


        :param display_name: The display_name of this ModifyModelGroupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ModifyModelGroupDetails.
        A short description of the modelGroup.


        :return: The description of this ModifyModelGroupDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ModifyModelGroupDetails.
        A short description of the modelGroup.


        :param description: The description of this ModifyModelGroupDetails.
        :type: str
        """
        self._description = description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ModifyModelGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ModifyModelGroupDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ModifyModelGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ModifyModelGroupDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ModifyModelGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ModifyModelGroupDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ModifyModelGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ModifyModelGroupDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def model_group_version_history_id(self):
        """
        Gets the model_group_version_history_id of this ModifyModelGroupDetails.
        The `OCID`__ of the model group version history to which the modelGroup is associated.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The model_group_version_history_id of this ModifyModelGroupDetails.
        :rtype: str
        """
        return self._model_group_version_history_id

    @model_group_version_history_id.setter
    def model_group_version_history_id(self, model_group_version_history_id):
        """
        Sets the model_group_version_history_id of this ModifyModelGroupDetails.
        The `OCID`__ of the model group version history to which the modelGroup is associated.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param model_group_version_history_id: The model_group_version_history_id of this ModifyModelGroupDetails.
        :type: str
        """
        self._model_group_version_history_id = model_group_version_history_id

    @property
    def version_label(self):
        """
        Gets the version_label of this ModifyModelGroupDetails.
        An additional description of the lifecycle state of the model group.


        :return: The version_label of this ModifyModelGroupDetails.
        :rtype: str
        """
        return self._version_label

    @version_label.setter
    def version_label(self, version_label):
        """
        Sets the version_label of this ModifyModelGroupDetails.
        An additional description of the lifecycle state of the model group.


        :param version_label: The version_label of this ModifyModelGroupDetails.
        :type: str
        """
        self._version_label = version_label

    @property
    def model_group_details(self):
        """
        Gets the model_group_details of this ModifyModelGroupDetails.

        :return: The model_group_details of this ModifyModelGroupDetails.
        :rtype: oci.data_science.models.ModelGroupDetails
        """
        return self._model_group_details

    @model_group_details.setter
    def model_group_details(self, model_group_details):
        """
        Sets the model_group_details of this ModifyModelGroupDetails.

        :param model_group_details: The model_group_details of this ModifyModelGroupDetails.
        :type: oci.data_science.models.ModelGroupDetails
        """
        self._model_group_details = model_group_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
