# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .scaling_policy import ScalingPolicy
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FixedSizeScalingPolicy(ScalingPolicy):
    """
    The fixed size scaling policy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FixedSizeScalingPolicy object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.FixedSizeScalingPolicy.policy_type` attribute
        of this class is ``FIXED_SIZE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param policy_type:
            The value to assign to the policy_type property of this FixedSizeScalingPolicy.
            Allowed values for this property are: "FIXED_SIZE", "AUTOSCALING"
        :type policy_type: str

        :param instance_count:
            The value to assign to the instance_count property of this FixedSizeScalingPolicy.
        :type instance_count: int

        """
        self.swagger_types = {
            'policy_type': 'str',
            'instance_count': 'int'
        }
        self.attribute_map = {
            'policy_type': 'policyType',
            'instance_count': 'instanceCount'
        }
        self._policy_type = None
        self._instance_count = None
        self._policy_type = 'FIXED_SIZE'

    @property
    def instance_count(self):
        """
        **[Required]** Gets the instance_count of this FixedSizeScalingPolicy.
        The number of instances for the model deployment.


        :return: The instance_count of this FixedSizeScalingPolicy.
        :rtype: int
        """
        return self._instance_count

    @instance_count.setter
    def instance_count(self, instance_count):
        """
        Sets the instance_count of this FixedSizeScalingPolicy.
        The number of instances for the model deployment.


        :param instance_count: The instance_count of this FixedSizeScalingPolicy.
        :type: int
        """
        self._instance_count = instance_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
