# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAuditPolicyDefinition(object):
    """
    Resource represents a single unified audit policy definition.
    """

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the audit_policy_category property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "BASIC_ACTIVITY"
    AUDIT_POLICY_CATEGORY_BASIC_ACTIVITY = "BASIC_ACTIVITY"

    #: A constant which can be used with the audit_policy_category property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "ADMIN_USER_ACTIVITY"
    AUDIT_POLICY_CATEGORY_ADMIN_USER_ACTIVITY = "ADMIN_USER_ACTIVITY"

    #: A constant which can be used with the audit_policy_category property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "USER_ACTIVITY"
    AUDIT_POLICY_CATEGORY_USER_ACTIVITY = "USER_ACTIVITY"

    #: A constant which can be used with the audit_policy_category property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "ORACLE_PREDEFINED"
    AUDIT_POLICY_CATEGORY_ORACLE_PREDEFINED = "ORACLE_PREDEFINED"

    #: A constant which can be used with the audit_policy_category property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "COMPLIANCE_STANDARD"
    AUDIT_POLICY_CATEGORY_COMPLIANCE_STANDARD = "COMPLIANCE_STANDARD"

    #: A constant which can be used with the audit_policy_category property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "SQL_FIREWALL_AUDITING"
    AUDIT_POLICY_CATEGORY_SQL_FIREWALL_AUDITING = "SQL_FIREWALL_AUDITING"

    #: A constant which can be used with the audit_policy_category property of a UnifiedAuditPolicyDefinition.
    #: This constant has a value of "CUSTOM"
    AUDIT_POLICY_CATEGORY_CUSTOM = "CUSTOM"

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAuditPolicyDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this UnifiedAuditPolicyDefinition.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this UnifiedAuditPolicyDefinition.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this UnifiedAuditPolicyDefinition.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UnifiedAuditPolicyDefinition.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this UnifiedAuditPolicyDefinition.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "FAILED", "DELETING", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this UnifiedAuditPolicyDefinition.
        :type lifecycle_details: str

        :param policy_name:
            The value to assign to the policy_name property of this UnifiedAuditPolicyDefinition.
        :type policy_name: str

        :param is_seeded:
            The value to assign to the is_seeded property of this UnifiedAuditPolicyDefinition.
        :type is_seeded: bool

        :param audit_policy_category:
            The value to assign to the audit_policy_category property of this UnifiedAuditPolicyDefinition.
            Allowed values for this property are: "BASIC_ACTIVITY", "ADMIN_USER_ACTIVITY", "USER_ACTIVITY", "ORACLE_PREDEFINED", "COMPLIANCE_STANDARD", "SQL_FIREWALL_AUDITING", "CUSTOM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type audit_policy_category: str

        :param time_created:
            The value to assign to the time_created property of this UnifiedAuditPolicyDefinition.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this UnifiedAuditPolicyDefinition.
        :type time_updated: datetime

        :param policy_definition_statement:
            The value to assign to the policy_definition_statement property of this UnifiedAuditPolicyDefinition.
        :type policy_definition_statement: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UnifiedAuditPolicyDefinition.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UnifiedAuditPolicyDefinition.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this UnifiedAuditPolicyDefinition.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'policy_name': 'str',
            'is_seeded': 'bool',
            'audit_policy_category': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'policy_definition_statement': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'policy_name': 'policyName',
            'is_seeded': 'isSeeded',
            'audit_policy_category': 'auditPolicyCategory',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'policy_definition_statement': 'policyDefinitionStatement',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._policy_name = None
        self._is_seeded = None
        self._audit_policy_category = None
        self._time_created = None
        self._time_updated = None
        self._policy_definition_statement = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this UnifiedAuditPolicyDefinition.
        The OCID of the unified audit policy definition.


        :return: The id of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this UnifiedAuditPolicyDefinition.
        The OCID of the unified audit policy definition.


        :param id: The id of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this UnifiedAuditPolicyDefinition.
        The OCID of the compartment containing the unified audit policy definition.


        :return: The compartment_id of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this UnifiedAuditPolicyDefinition.
        The OCID of the compartment containing the unified audit policy definition.


        :param compartment_id: The compartment_id of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this UnifiedAuditPolicyDefinition.
        The display name of the unified audit policy definition.


        :return: The display_name of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UnifiedAuditPolicyDefinition.
        The display name of the unified audit policy definition.


        :param display_name: The display_name of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UnifiedAuditPolicyDefinition.
        The description of the unified audit policy definition.


        :return: The description of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UnifiedAuditPolicyDefinition.
        The description of the unified audit policy definition.


        :param description: The description of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this UnifiedAuditPolicyDefinition.
        The current state of the unified audit policy definition.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "FAILED", "DELETING", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this UnifiedAuditPolicyDefinition.
        The current state of the unified audit policy definition.


        :param lifecycle_state: The lifecycle_state of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "FAILED", "DELETING", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this UnifiedAuditPolicyDefinition.
        Details about the current state of the unified audit policy definition.


        :return: The lifecycle_details of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this UnifiedAuditPolicyDefinition.
        Details about the current state of the unified audit policy definition.


        :param lifecycle_details: The lifecycle_details of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def policy_name(self):
        """
        Gets the policy_name of this UnifiedAuditPolicyDefinition.
        The unified audit policy name in the target database.


        :return: The policy_name of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._policy_name

    @policy_name.setter
    def policy_name(self, policy_name):
        """
        Sets the policy_name of this UnifiedAuditPolicyDefinition.
        The unified audit policy name in the target database.


        :param policy_name: The policy_name of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        self._policy_name = policy_name

    @property
    def is_seeded(self):
        """
        Gets the is_seeded of this UnifiedAuditPolicyDefinition.
        Signifies whether the unified audit policy definition is seeded or not.


        :return: The is_seeded of this UnifiedAuditPolicyDefinition.
        :rtype: bool
        """
        return self._is_seeded

    @is_seeded.setter
    def is_seeded(self, is_seeded):
        """
        Sets the is_seeded of this UnifiedAuditPolicyDefinition.
        Signifies whether the unified audit policy definition is seeded or not.


        :param is_seeded: The is_seeded of this UnifiedAuditPolicyDefinition.
        :type: bool
        """
        self._is_seeded = is_seeded

    @property
    def audit_policy_category(self):
        """
        Gets the audit_policy_category of this UnifiedAuditPolicyDefinition.
        The category to which the unified audit policy belongs in the target database.

        Allowed values for this property are: "BASIC_ACTIVITY", "ADMIN_USER_ACTIVITY", "USER_ACTIVITY", "ORACLE_PREDEFINED", "COMPLIANCE_STANDARD", "SQL_FIREWALL_AUDITING", "CUSTOM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The audit_policy_category of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._audit_policy_category

    @audit_policy_category.setter
    def audit_policy_category(self, audit_policy_category):
        """
        Sets the audit_policy_category of this UnifiedAuditPolicyDefinition.
        The category to which the unified audit policy belongs in the target database.


        :param audit_policy_category: The audit_policy_category of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        allowed_values = ["BASIC_ACTIVITY", "ADMIN_USER_ACTIVITY", "USER_ACTIVITY", "ORACLE_PREDEFINED", "COMPLIANCE_STANDARD", "SQL_FIREWALL_AUDITING", "CUSTOM"]
        if not value_allowed_none_or_none_sentinel(audit_policy_category, allowed_values):
            audit_policy_category = 'UNKNOWN_ENUM_VALUE'
        self._audit_policy_category = audit_policy_category

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this UnifiedAuditPolicyDefinition.
        The time the unified audit policy was created, in the format defined by RFC3339.


        :return: The time_created of this UnifiedAuditPolicyDefinition.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this UnifiedAuditPolicyDefinition.
        The time the unified audit policy was created, in the format defined by RFC3339.


        :param time_created: The time_created of this UnifiedAuditPolicyDefinition.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this UnifiedAuditPolicyDefinition.
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.


        :return: The time_updated of this UnifiedAuditPolicyDefinition.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this UnifiedAuditPolicyDefinition.
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.


        :param time_updated: The time_updated of this UnifiedAuditPolicyDefinition.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def policy_definition_statement(self):
        """
        Gets the policy_definition_statement of this UnifiedAuditPolicyDefinition.
        The definition of the unified audit policy to be provisioned in the target database.


        :return: The policy_definition_statement of this UnifiedAuditPolicyDefinition.
        :rtype: str
        """
        return self._policy_definition_statement

    @policy_definition_statement.setter
    def policy_definition_statement(self, policy_definition_statement):
        """
        Sets the policy_definition_statement of this UnifiedAuditPolicyDefinition.
        The definition of the unified audit policy to be provisioned in the target database.


        :param policy_definition_statement: The policy_definition_statement of this UnifiedAuditPolicyDefinition.
        :type: str
        """
        self._policy_definition_statement = policy_definition_statement

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UnifiedAuditPolicyDefinition.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UnifiedAuditPolicyDefinition.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UnifiedAuditPolicyDefinition.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UnifiedAuditPolicyDefinition.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UnifiedAuditPolicyDefinition.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UnifiedAuditPolicyDefinition.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UnifiedAuditPolicyDefinition.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UnifiedAuditPolicyDefinition.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this UnifiedAuditPolicyDefinition.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this UnifiedAuditPolicyDefinition.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this UnifiedAuditPolicyDefinition.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this UnifiedAuditPolicyDefinition.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
