# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSecurityPolicyDeploymentDetails(object):
    """
    Details to create the security policy deployment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSecurityPolicyDeploymentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateSecurityPolicyDeploymentDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateSecurityPolicyDeploymentDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateSecurityPolicyDeploymentDetails.
        :type compartment_id: str

        :param target_id:
            The value to assign to the target_id property of this CreateSecurityPolicyDeploymentDetails.
        :type target_id: str

        :param target_type:
            The value to assign to the target_type property of this CreateSecurityPolicyDeploymentDetails.
        :type target_type: str

        :param security_policy_id:
            The value to assign to the security_policy_id property of this CreateSecurityPolicyDeploymentDetails.
        :type security_policy_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateSecurityPolicyDeploymentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateSecurityPolicyDeploymentDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'target_id': 'str',
            'target_type': 'str',
            'security_policy_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'target_id': 'targetId',
            'target_type': 'targetType',
            'security_policy_id': 'securityPolicyId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._target_id = None
        self._target_type = None
        self._security_policy_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateSecurityPolicyDeploymentDetails.
        The display name of the security policy deployment. The name does not have to be unique, and it is changeable.


        :return: The display_name of this CreateSecurityPolicyDeploymentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateSecurityPolicyDeploymentDetails.
        The display name of the security policy deployment. The name does not have to be unique, and it is changeable.


        :param display_name: The display_name of this CreateSecurityPolicyDeploymentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateSecurityPolicyDeploymentDetails.
        The description of the security policy.


        :return: The description of this CreateSecurityPolicyDeploymentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateSecurityPolicyDeploymentDetails.
        The description of the security policy.


        :param description: The description of this CreateSecurityPolicyDeploymentDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateSecurityPolicyDeploymentDetails.
        The OCID of the compartment in which to create the unified audit policy.


        :return: The compartment_id of this CreateSecurityPolicyDeploymentDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateSecurityPolicyDeploymentDetails.
        The OCID of the compartment in which to create the unified audit policy.


        :param compartment_id: The compartment_id of this CreateSecurityPolicyDeploymentDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this CreateSecurityPolicyDeploymentDetails.
        The OCID of the target where the security policy is deployed.


        :return: The target_id of this CreateSecurityPolicyDeploymentDetails.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this CreateSecurityPolicyDeploymentDetails.
        The OCID of the target where the security policy is deployed.


        :param target_id: The target_id of this CreateSecurityPolicyDeploymentDetails.
        :type: str
        """
        self._target_id = target_id

    @property
    def target_type(self):
        """
        **[Required]** Gets the target_type of this CreateSecurityPolicyDeploymentDetails.
        Indicates whether the security policy deployment is for a target database or a target database group.


        :return: The target_type of this CreateSecurityPolicyDeploymentDetails.
        :rtype: str
        """
        return self._target_type

    @target_type.setter
    def target_type(self, target_type):
        """
        Sets the target_type of this CreateSecurityPolicyDeploymentDetails.
        Indicates whether the security policy deployment is for a target database or a target database group.


        :param target_type: The target_type of this CreateSecurityPolicyDeploymentDetails.
        :type: str
        """
        self._target_type = target_type

    @property
    def security_policy_id(self):
        """
        **[Required]** Gets the security_policy_id of this CreateSecurityPolicyDeploymentDetails.
        The OCID of the security policy corresponding to the security policy deployment.


        :return: The security_policy_id of this CreateSecurityPolicyDeploymentDetails.
        :rtype: str
        """
        return self._security_policy_id

    @security_policy_id.setter
    def security_policy_id(self, security_policy_id):
        """
        Sets the security_policy_id of this CreateSecurityPolicyDeploymentDetails.
        The OCID of the security policy corresponding to the security policy deployment.


        :param security_policy_id: The security_policy_id of this CreateSecurityPolicyDeploymentDetails.
        :type: str
        """
        self._security_policy_id = security_policy_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateSecurityPolicyDeploymentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateSecurityPolicyDeploymentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateSecurityPolicyDeploymentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateSecurityPolicyDeploymentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateSecurityPolicyDeploymentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateSecurityPolicyDeploymentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateSecurityPolicyDeploymentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateSecurityPolicyDeploymentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
