# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LaunchInstanceLicensingConfig(object):
    """
    The license config requested for the instance.
    """

    #: A constant which can be used with the type property of a LaunchInstanceLicensingConfig.
    #: This constant has a value of "WINDOWS"
    TYPE_WINDOWS = "WINDOWS"

    #: A constant which can be used with the license_type property of a LaunchInstanceLicensingConfig.
    #: This constant has a value of "OCI_PROVIDED"
    LICENSE_TYPE_OCI_PROVIDED = "OCI_PROVIDED"

    #: A constant which can be used with the license_type property of a LaunchInstanceLicensingConfig.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_TYPE_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    def __init__(self, **kwargs):
        """
        Initializes a new LaunchInstanceLicensingConfig object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.core.models.LaunchInstanceWindowsLicensingConfig`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this LaunchInstanceLicensingConfig.
            Allowed values for this property are: "WINDOWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param license_type:
            The value to assign to the license_type property of this LaunchInstanceLicensingConfig.
            Allowed values for this property are: "OCI_PROVIDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type license_type: str

        """
        self.swagger_types = {
            'type': 'str',
            'license_type': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'license_type': 'licenseType'
        }
        self._type = None
        self._license_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'WINDOWS':
            return 'LaunchInstanceWindowsLicensingConfig'
        else:
            return 'LaunchInstanceLicensingConfig'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this LaunchInstanceLicensingConfig.
        Operating System type of the Configuration.

        Allowed values for this property are: "WINDOWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this LaunchInstanceLicensingConfig.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this LaunchInstanceLicensingConfig.
        Operating System type of the Configuration.


        :param type: The type of this LaunchInstanceLicensingConfig.
        :type: str
        """
        allowed_values = ["WINDOWS"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def license_type(self):
        """
        Gets the license_type of this LaunchInstanceLicensingConfig.
        License Type for the OS license.
        * `OCI_PROVIDED` - OCI provided license (e.g. metered $/OCPU-hour).
        * `BRING_YOUR_OWN_LICENSE` - Bring your own license.

        Allowed values for this property are: "OCI_PROVIDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The license_type of this LaunchInstanceLicensingConfig.
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """
        Sets the license_type of this LaunchInstanceLicensingConfig.
        License Type for the OS license.
        * `OCI_PROVIDED` - OCI provided license (e.g. metered $/OCPU-hour).
        * `BRING_YOUR_OWN_LICENSE` - Bring your own license.


        :param license_type: The license_type of this LaunchInstanceLicensingConfig.
        :type: str
        """
        allowed_values = ["OCI_PROVIDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_type, allowed_values):
            license_type = 'UNKNOWN_ENUM_VALUE'
        self._license_type = license_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
