# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstancePoolLifecycleActionsDetails(object):
    """
    The lifecycle actions for the instance pool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstancePoolLifecycleActionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pre_termination:
            The value to assign to the pre_termination property of this InstancePoolLifecycleActionsDetails.
        :type pre_termination: oci.core.models.InstancePoolPreTerminationActionDetails

        """
        self.swagger_types = {
            'pre_termination': 'InstancePoolPreTerminationActionDetails'
        }
        self.attribute_map = {
            'pre_termination': 'preTermination'
        }
        self._pre_termination = None

    @property
    def pre_termination(self):
        """
        Gets the pre_termination of this InstancePoolLifecycleActionsDetails.

        :return: The pre_termination of this InstancePoolLifecycleActionsDetails.
        :rtype: oci.core.models.InstancePoolPreTerminationActionDetails
        """
        return self._pre_termination

    @pre_termination.setter
    def pre_termination(self, pre_termination):
        """
        Sets the pre_termination of this InstancePoolLifecycleActionsDetails.

        :param pre_termination: The pre_termination of this InstancePoolLifecycleActionsDetails.
        :type: oci.core.models.InstancePoolPreTerminationActionDetails
        """
        self._pre_termination = pre_termination

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
