# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeGpuMemoryCluster(object):
    """
    The customer facing object includes GPU memory cluster details.
    """

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryCluster.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryCluster.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryCluster.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryCluster.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryCluster.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeGpuMemoryCluster object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this ComputeGpuMemoryCluster.
        :type availability_domain: str

        :param id:
            The value to assign to the id property of this ComputeGpuMemoryCluster.
        :type id: str

        :param instance_configuration_id:
            The value to assign to the instance_configuration_id property of this ComputeGpuMemoryCluster.
        :type instance_configuration_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ComputeGpuMemoryCluster.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeGpuMemoryCluster.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param gpu_memory_fabric_id:
            The value to assign to the gpu_memory_fabric_id property of this ComputeGpuMemoryCluster.
        :type gpu_memory_fabric_id: str

        :param compute_cluster_id:
            The value to assign to the compute_cluster_id property of this ComputeGpuMemoryCluster.
        :type compute_cluster_id: str

        :param size:
            The value to assign to the size property of this ComputeGpuMemoryCluster.
        :type size: int

        :param gpu_memory_cluster_scale_config:
            The value to assign to the gpu_memory_cluster_scale_config property of this ComputeGpuMemoryCluster.
        :type gpu_memory_cluster_scale_config: oci.core.models.ComputeGpuMemoryClusterScaleConfig

        :param defined_tags:
            The value to assign to the defined_tags property of this ComputeGpuMemoryCluster.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ComputeGpuMemoryCluster.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this ComputeGpuMemoryCluster.
        :type system_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this ComputeGpuMemoryCluster.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this ComputeGpuMemoryCluster.
        :type time_created: datetime

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'id': 'str',
            'instance_configuration_id': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'gpu_memory_fabric_id': 'str',
            'compute_cluster_id': 'str',
            'size': 'int',
            'gpu_memory_cluster_scale_config': 'ComputeGpuMemoryClusterScaleConfig',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'id': 'id',
            'instance_configuration_id': 'instanceConfigurationId',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'gpu_memory_fabric_id': 'gpuMemoryFabricId',
            'compute_cluster_id': 'computeClusterId',
            'size': 'size',
            'gpu_memory_cluster_scale_config': 'gpuMemoryClusterScaleConfig',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags',
            'display_name': 'displayName',
            'time_created': 'timeCreated'
        }
        self._availability_domain = None
        self._id = None
        self._instance_configuration_id = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._gpu_memory_fabric_id = None
        self._compute_cluster_id = None
        self._size = None
        self._gpu_memory_cluster_scale_config = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None
        self._display_name = None
        self._time_created = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this ComputeGpuMemoryCluster.
        The availability domain of the GPU memory cluster.


        :return: The availability_domain of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this ComputeGpuMemoryCluster.
        The availability domain of the GPU memory cluster.


        :param availability_domain: The availability_domain of this ComputeGpuMemoryCluster.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ComputeGpuMemoryCluster.
        The `OCID`__ for the Customer-unique GPU memory cluster

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComputeGpuMemoryCluster.
        The `OCID`__ for the Customer-unique GPU memory cluster

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ComputeGpuMemoryCluster.
        :type: str
        """
        self._id = id

    @property
    def instance_configuration_id(self):
        """
        **[Required]** Gets the instance_configuration_id of this ComputeGpuMemoryCluster.
        The OCID of the Instance Configuration used to source launch details for this instance.


        :return: The instance_configuration_id of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._instance_configuration_id

    @instance_configuration_id.setter
    def instance_configuration_id(self, instance_configuration_id):
        """
        Sets the instance_configuration_id of this ComputeGpuMemoryCluster.
        The OCID of the Instance Configuration used to source launch details for this instance.


        :param instance_configuration_id: The instance_configuration_id of this ComputeGpuMemoryCluster.
        :type: str
        """
        self._instance_configuration_id = instance_configuration_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ComputeGpuMemoryCluster.
        The `OCID`__ of the compartment that contains the compute GPU
        memory cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ComputeGpuMemoryCluster.
        The `OCID`__ of the compartment that contains the compute GPU
        memory cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ComputeGpuMemoryCluster.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ComputeGpuMemoryCluster.
        The lifecycle state of the GPU memory cluster

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ComputeGpuMemoryCluster.
        The lifecycle state of the GPU memory cluster


        :param lifecycle_state: The lifecycle_state of this ComputeGpuMemoryCluster.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def gpu_memory_fabric_id(self):
        """
        Gets the gpu_memory_fabric_id of this ComputeGpuMemoryCluster.
        The `OCID`__ of the GPU memory fabric.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The gpu_memory_fabric_id of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._gpu_memory_fabric_id

    @gpu_memory_fabric_id.setter
    def gpu_memory_fabric_id(self, gpu_memory_fabric_id):
        """
        Sets the gpu_memory_fabric_id of this ComputeGpuMemoryCluster.
        The `OCID`__ of the GPU memory fabric.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param gpu_memory_fabric_id: The gpu_memory_fabric_id of this ComputeGpuMemoryCluster.
        :type: str
        """
        self._gpu_memory_fabric_id = gpu_memory_fabric_id

    @property
    def compute_cluster_id(self):
        """
        **[Required]** Gets the compute_cluster_id of this ComputeGpuMemoryCluster.
        The `OCID`__ of the compute cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_cluster_id of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._compute_cluster_id

    @compute_cluster_id.setter
    def compute_cluster_id(self, compute_cluster_id):
        """
        Sets the compute_cluster_id of this ComputeGpuMemoryCluster.
        The `OCID`__ of the compute cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_cluster_id: The compute_cluster_id of this ComputeGpuMemoryCluster.
        :type: str
        """
        self._compute_cluster_id = compute_cluster_id

    @property
    def size(self):
        """
        **[Required]** Gets the size of this ComputeGpuMemoryCluster.
        The number of instances currently running in the GpuMemoryCluster


        :return: The size of this ComputeGpuMemoryCluster.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this ComputeGpuMemoryCluster.
        The number of instances currently running in the GpuMemoryCluster


        :param size: The size of this ComputeGpuMemoryCluster.
        :type: int
        """
        self._size = size

    @property
    def gpu_memory_cluster_scale_config(self):
        """
        Gets the gpu_memory_cluster_scale_config of this ComputeGpuMemoryCluster.

        :return: The gpu_memory_cluster_scale_config of this ComputeGpuMemoryCluster.
        :rtype: oci.core.models.ComputeGpuMemoryClusterScaleConfig
        """
        return self._gpu_memory_cluster_scale_config

    @gpu_memory_cluster_scale_config.setter
    def gpu_memory_cluster_scale_config(self, gpu_memory_cluster_scale_config):
        """
        Sets the gpu_memory_cluster_scale_config of this ComputeGpuMemoryCluster.

        :param gpu_memory_cluster_scale_config: The gpu_memory_cluster_scale_config of this ComputeGpuMemoryCluster.
        :type: oci.core.models.ComputeGpuMemoryClusterScaleConfig
        """
        self._gpu_memory_cluster_scale_config = gpu_memory_cluster_scale_config

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ComputeGpuMemoryCluster.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ComputeGpuMemoryCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ComputeGpuMemoryCluster.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ComputeGpuMemoryCluster.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ComputeGpuMemoryCluster.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ComputeGpuMemoryCluster.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ComputeGpuMemoryCluster.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ComputeGpuMemoryCluster.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ComputeGpuMemoryCluster.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :return: The system_tags of this ComputeGpuMemoryCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ComputeGpuMemoryCluster.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :param system_tags: The system_tags of this ComputeGpuMemoryCluster.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this ComputeGpuMemoryCluster.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this ComputeGpuMemoryCluster.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ComputeGpuMemoryCluster.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this ComputeGpuMemoryCluster.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ComputeGpuMemoryCluster.
        The date and time the GPU memory cluster was created.

        Example: `2016-09-15T21:10:29.600Z`


        :return: The time_created of this ComputeGpuMemoryCluster.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ComputeGpuMemoryCluster.
        The date and time the GPU memory cluster was created.

        Example: `2016-09-15T21:10:29.600Z`


        :param time_created: The time_created of this ComputeGpuMemoryCluster.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
