# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Byoasn(object):
    """
    Oracle offers the ability to Bring Your Own Autonomous System Number (BYOASN), importing AS Numbers you currently own to Oracle Cloud Infrastructure. A `Byoasn` resource is a record of the imported AS Number and also some associated metadata. The process used to `Bring Your Own ASN`__ is explained in the documentation.

    __ https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/BYOASN.htm
    """

    #: A constant which can be used with the lifecycle_state property of a Byoasn.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Byoasn.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Byoasn.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Byoasn.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a Byoasn.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    def __init__(self, **kwargs):
        """
        Initializes a new Byoasn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Byoasn.
            Allowed values for this property are: "UPDATING", "ACTIVE", "DELETED", "FAILED", "CREATING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param defined_tags:
            The value to assign to the defined_tags property of this Byoasn.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this Byoasn.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Byoasn.
        :type freeform_tags: dict(str, str)

        :param id:
            The value to assign to the id property of this Byoasn.
        :type id: str

        :param asn:
            The value to assign to the asn property of this Byoasn.
        :type asn: int

        :param compartment_id:
            The value to assign to the compartment_id property of this Byoasn.
        :type compartment_id: str

        :param time_validated:
            The value to assign to the time_validated property of this Byoasn.
        :type time_validated: datetime

        :param validation_token:
            The value to assign to the validation_token property of this Byoasn.
        :type validation_token: str

        :param time_created:
            The value to assign to the time_created property of this Byoasn.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Byoasn.
        :type time_updated: datetime

        :param byoip_ranges:
            The value to assign to the byoip_ranges property of this Byoasn.
        :type byoip_ranges: list[oci.core.models.ByoasnByoipRange]

        """
        self.swagger_types = {
            'lifecycle_state': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'id': 'str',
            'asn': 'int',
            'compartment_id': 'str',
            'time_validated': 'datetime',
            'validation_token': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'byoip_ranges': 'list[ByoasnByoipRange]'
        }
        self.attribute_map = {
            'lifecycle_state': 'lifecycleState',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'id': 'id',
            'asn': 'asn',
            'compartment_id': 'compartmentId',
            'time_validated': 'timeValidated',
            'validation_token': 'validationToken',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'byoip_ranges': 'byoipRanges'
        }
        self._lifecycle_state = None
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None
        self._id = None
        self._asn = None
        self._compartment_id = None
        self._time_validated = None
        self._validation_token = None
        self._time_created = None
        self._time_updated = None
        self._byoip_ranges = None

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Byoasn.
        The `Byoasn` resource's current state.

        Allowed values for this property are: "UPDATING", "ACTIVE", "DELETED", "FAILED", "CREATING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Byoasn.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Byoasn.
        The `Byoasn` resource's current state.


        :param lifecycle_state: The lifecycle_state of this Byoasn.
        :type: str
        """
        allowed_values = ["UPDATING", "ACTIVE", "DELETED", "FAILED", "CREATING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Byoasn.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Byoasn.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Byoasn.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Byoasn.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this Byoasn.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this Byoasn.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Byoasn.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this Byoasn.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Byoasn.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Byoasn.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Byoasn.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Byoasn.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Byoasn.
        The `OCID`__ of the `Byoasn` resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this Byoasn.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Byoasn.
        The `OCID`__ of the `Byoasn` resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this Byoasn.
        :type: str
        """
        self._id = id

    @property
    def asn(self):
        """
        **[Required]** Gets the asn of this Byoasn.
        The Autonomous System Number (ASN) you are importing to the Oracle cloud.


        :return: The asn of this Byoasn.
        :rtype: int
        """
        return self._asn

    @asn.setter
    def asn(self, asn):
        """
        Sets the asn of this Byoasn.
        The Autonomous System Number (ASN) you are importing to the Oracle cloud.


        :param asn: The asn of this Byoasn.
        :type: int
        """
        self._asn = asn

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Byoasn.
        The `OCID`__ of the compartment containing the `Byoasn` resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Byoasn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Byoasn.
        The `OCID`__ of the compartment containing the `Byoasn` resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Byoasn.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_validated(self):
        """
        Gets the time_validated of this Byoasn.
        The date and time the `Byoasn` resource was validated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_validated of this Byoasn.
        :rtype: datetime
        """
        return self._time_validated

    @time_validated.setter
    def time_validated(self, time_validated):
        """
        Sets the time_validated of this Byoasn.
        The date and time the `Byoasn` resource was validated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_validated: The time_validated of this Byoasn.
        :type: datetime
        """
        self._time_validated = time_validated

    @property
    def validation_token(self):
        """
        **[Required]** Gets the validation_token of this Byoasn.
        The validation token is an internally-generated ASCII string used in the validation process. See `Importing a Byoasn`__ for details.

        __ https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/BYOASN.htm


        :return: The validation_token of this Byoasn.
        :rtype: str
        """
        return self._validation_token

    @validation_token.setter
    def validation_token(self, validation_token):
        """
        Sets the validation_token of this Byoasn.
        The validation token is an internally-generated ASCII string used in the validation process. See `Importing a Byoasn`__ for details.

        __ https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/BYOASN.htm


        :param validation_token: The validation_token of this Byoasn.
        :type: str
        """
        self._validation_token = validation_token

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Byoasn.
        The date and time the `Byoasn` resource was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this Byoasn.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Byoasn.
        The date and time the `Byoasn` resource was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this Byoasn.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Byoasn.
        The date and time the `Byoasn` resource was last updated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this Byoasn.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Byoasn.
        The date and time the `Byoasn` resource was last updated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this Byoasn.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def byoip_ranges(self):
        """
        Gets the byoip_ranges of this Byoasn.
        The BYOIP Ranges that has the `Byoasn` as origin.


        :return: The byoip_ranges of this Byoasn.
        :rtype: list[oci.core.models.ByoasnByoipRange]
        """
        return self._byoip_ranges

    @byoip_ranges.setter
    def byoip_ranges(self, byoip_ranges):
        """
        Sets the byoip_ranges of this Byoasn.
        The BYOIP Ranges that has the `Byoasn` as origin.


        :param byoip_ranges: The byoip_ranges of this Byoasn.
        :type: list[oci.core.models.ByoasnByoipRange]
        """
        self._byoip_ranges = byoip_ranges

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
