# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkDetachPrivateIpsDetails(object):
    """
    Bulk Secondary IPv4 addresses detach object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkDetachPrivateIpsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vnic_id:
            The value to assign to the vnic_id property of this BulkDetachPrivateIpsDetails.
        :type vnic_id: str

        :param bulk_detach_private_ip_item:
            The value to assign to the bulk_detach_private_ip_item property of this BulkDetachPrivateIpsDetails.
        :type bulk_detach_private_ip_item: list[oci.core.models.BulkDetachPrivateIpItem]

        """
        self.swagger_types = {
            'vnic_id': 'str',
            'bulk_detach_private_ip_item': 'list[BulkDetachPrivateIpItem]'
        }
        self.attribute_map = {
            'vnic_id': 'vnicId',
            'bulk_detach_private_ip_item': 'bulkDetachPrivateIpItem'
        }
        self._vnic_id = None
        self._bulk_detach_private_ip_item = None

    @property
    def vnic_id(self):
        """
        Gets the vnic_id of this BulkDetachPrivateIpsDetails.
        The `OCID`__ of the VNIC of which private IPs should be detached. The VNIC and private IPs must be in the same subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vnic_id of this BulkDetachPrivateIpsDetails.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this BulkDetachPrivateIpsDetails.
        The `OCID`__ of the VNIC of which private IPs should be detached. The VNIC and private IPs must be in the same subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vnic_id: The vnic_id of this BulkDetachPrivateIpsDetails.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def bulk_detach_private_ip_item(self):
        """
        **[Required]** Gets the bulk_detach_private_ip_item of this BulkDetachPrivateIpsDetails.
        Secondary IPv4 addresses to detached.


        :return: The bulk_detach_private_ip_item of this BulkDetachPrivateIpsDetails.
        :rtype: list[oci.core.models.BulkDetachPrivateIpItem]
        """
        return self._bulk_detach_private_ip_item

    @bulk_detach_private_ip_item.setter
    def bulk_detach_private_ip_item(self, bulk_detach_private_ip_item):
        """
        Sets the bulk_detach_private_ip_item of this BulkDetachPrivateIpsDetails.
        Secondary IPv4 addresses to detached.


        :param bulk_detach_private_ip_item: The bulk_detach_private_ip_item of this BulkDetachPrivateIpsDetails.
        :type: list[oci.core.models.BulkDetachPrivateIpItem]
        """
        self._bulk_detach_private_ip_item = bulk_detach_private_ip_item

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
